/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.command;

import java.util.List;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.commons.beanutils.PropertyUtils;
import org.aspectj.lang.SoftException;
import protoj.lang.Command;
import protoj.lang.CommandStore;
import protoj.lang.DispatchFeature;
import protoj.lang.InstructionChain;
import protoj.lang.StandardProject;
import protoj.util.ArgRunnable;
import protoj.util.JavaTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaCommand {
    private Command delegate;
    private final DispatchFeature parent;
    private OptionSpec<String> optOption;

    public void startVm(final List<String> opts) {
        try {
            final StandardProject project = this.parent.getParent();
            InstructionChain chain = project.getInstructionChain();
            String[] args = chain.createArgsAndRemove(true);
            DispatchFeature dispatchFeature = project.getDispatchFeature();
            dispatchFeature.startVm(null, args, null, new ArgRunnable<JavaTask>(){
                {
                    try {
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }

                @Override
                public void run(JavaTask command) {
                    try {
                        project.getLogger().info((Object)"applying java options:");
                        for (String opt : opts) {
                            String[] property = opt.split("=");
                            String name = property[0];
                            String value = property[1];
                            project.getLogger().info((Object)String.format("%s=%s", name, value));
                            PropertyUtils.setProperty((Object)command, (String)name, (Object)value);
                        }
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }
            });
            chain.breakVisit();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public JavaCommand(DispatchFeature dispatchFeature) {
        try {
            this.parent = dispatchFeature;
            CommandStore store = dispatchFeature.getParent().getCommandStore();
            this.delegate = store.addCommand("java", "16m", new Body());
            this.delegate.initHelpResource("/protoj-common/language/english/java.txt");
            this.delegate.initBootstrapCurrentVm();
            this.optOption = this.delegate.getParser().accepts(this.getOptOption()).withRequiredArg();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getOptOption() {
        try {
            return "opt";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Command getDelegate() {
        try {
            return this.delegate;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ Command access$0(JavaCommand arg0) {
        try {
            return arg0.delegate;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpec access$1(JavaCommand arg0) {
        try {
            return arg0.optOption;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private final class Body
    implements Runnable {
        private Body() {
            try {
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }

        public void run() {
            try {
                OptionSet options = JavaCommand.access$0(JavaCommand.this).getOptions();
                if (options.has(JavaCommand.access$1(JavaCommand.this))) {
                    List javaOptions = options.valuesOf(JavaCommand.access$1(JavaCommand.this));
                    JavaCommand.this.startVm(javaOptions);
                }
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }
    }
}

