/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.command;

import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.aspectj.lang.SoftException;
import protoj.lang.Command;
import protoj.lang.CommandStore;
import protoj.lang.StandardProject;

public final class JunitCommand {
    private Command delegate;
    private OptionSpec<String> includes;
    private ArgumentAcceptingOptionSpec<String> excludes;
    private final StandardProject project;

    public JunitCommand(StandardProject project) {
        try {
            this.project = project;
            CommandStore store = project.getCommandStore();
            this.delegate = store.addCommand("junit", "16m", new Body());
            this.delegate.initHelpResource("/protoj-common/language/english/junit.txt");
            this.delegate.initAliases("test");
            OptionParser parser = this.delegate.getParser();
            this.includes = parser.accepts(this.getIncludesOption()).withRequiredArg();
            this.excludes = parser.accepts(this.getExcludesOption()).withRequiredArg();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getExcludesOption() {
        try {
            return "excludes";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getIncludesOption() {
        try {
            return "includes";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Command getDelegate() {
        try {
            return this.delegate;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpec access$0(JunitCommand arg0) {
        try {
            return arg0.includes;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ ArgumentAcceptingOptionSpec access$1(JunitCommand arg0) {
        try {
            return arg0.excludes;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ StandardProject access$2(JunitCommand arg0) {
        try {
            return arg0.project;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private final class Body
    implements Runnable {
        private Body() {
            try {
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }

        public void run() {
            try {
                Command delegate = JunitCommand.this.getDelegate();
                OptionSet options = delegate.getOptions();
                String include = (String)options.valueOf(JunitCommand.access$0(JunitCommand.this));
                String exclude = (String)options.valueOf((OptionSpec)JunitCommand.access$1(JunitCommand.this));
                if (include == null && exclude == null) {
                    JunitCommand.access$2(JunitCommand.this).getJunitFeature().junit();
                } else {
                    JunitCommand.access$2(JunitCommand.this).getJunitFeature().junit(include, exclude);
                }
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }
    }
}

