/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.command;

import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.aspectj.lang.SoftException;
import protoj.lang.Command;
import protoj.lang.CommandStore;
import protoj.lang.PublishFeature;
import protoj.lang.StandardProject;

public final class PublishCommand {
    private Command delegate;
    private OptionSpec<String> artifactOption;
    private StandardProject project;
    private OptionSpec<String> userOption;
    private OptionSpec<String> keyOption;
    private OptionSpec<String> passwordOption;
    private OptionSpec<String> passphraseOption;

    public PublishCommand(StandardProject project) {
        try {
            this.project = project;
            CommandStore store = project.getCommandStore();
            this.delegate = store.addCommand("publish", "16m", new Body());
            this.delegate.initHelpResource("/protoj-common/language/english/publish.txt");
            this.delegate.initAliases("deploy");
            this.artifactOption = this.delegate.getParser().accepts(this.getArtifactOption()).withRequiredArg();
            this.userOption = this.delegate.getParser().accepts(this.getUserOption()).withRequiredArg();
            this.keyOption = this.delegate.getParser().accepts(this.getKeyOption()).withRequiredArg();
            this.passwordOption = this.delegate.getParser().accepts(this.getPasswordOption()).withRequiredArg();
            this.passphraseOption = this.delegate.getParser().accepts(this.getPassphraseOption()).withRequiredArg();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getPassphraseOption() {
        try {
            return "passphrase";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getPasswordOption() {
        try {
            return "password";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getKeyOption() {
        try {
            return "key";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getUserOption() {
        try {
            return "user";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getArtifactOption() {
        try {
            return "artifact";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Command getDelegate() {
        try {
            return this.delegate;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpec access$0(PublishCommand arg0) {
        try {
            return arg0.userOption;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpec access$1(PublishCommand arg0) {
        try {
            return arg0.keyOption;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpec access$2(PublishCommand arg0) {
        try {
            return arg0.passwordOption;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpec access$3(PublishCommand arg0) {
        try {
            return arg0.passphraseOption;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ StandardProject access$4(PublishCommand arg0) {
        try {
            return arg0.project;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpec access$5(PublishCommand arg0) {
        try {
            return arg0.artifactOption;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public final class Body
    implements Runnable {
        public Body() {
            try {
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }

        public void run() {
            try {
                OptionSet options = PublishCommand.this.getDelegate().getOptions();
                String user = (String)options.valueOf(PublishCommand.access$0(PublishCommand.this));
                String key = (String)options.valueOf(PublishCommand.access$1(PublishCommand.this));
                String password = (String)options.valueOf(PublishCommand.access$2(PublishCommand.this));
                String passphrase = (String)options.valueOf(PublishCommand.access$3(PublishCommand.this));
                PublishFeature feature = PublishCommand.access$4(PublishCommand.this).getPublishFeature();
                if (options.has(PublishCommand.access$5(PublishCommand.this))) {
                    String artifact = (String)options.valueOf(PublishCommand.access$5(PublishCommand.this));
                    feature.deploy(artifact, user, key, password, passphrase);
                } else {
                    feature.deployAll(user, key, password, passphrase);
                }
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }
    }
}

