/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.command;

import java.io.File;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.aspectj.lang.SoftException;
import protoj.lang.Command;
import protoj.lang.CommandStore;
import protoj.lang.StandardProject;

public final class ScpCommand {
    private final StandardProject project;
    private Command delegate;
    private OptionSpec<File> keyFileOption;
    private OptionSpec<String> dirOption;
    private OptionSpec<String> passwordOption;
    private OptionSpec<String> phraseOption;
    private OptionSpec<String> archiveOption;

    public ScpCommand(StandardProject project) {
        try {
            this.project = project;
            CommandStore store = project.getCommandStore();
            this.delegate = store.addCommand("scp", "16m", new Body());
            this.delegate.initHelpResource("/protoj-common/language/english/scp.txt");
            OptionParser parser = this.delegate.getParser();
            this.archiveOption = parser.accepts(this.getArchiveOption()).withRequiredArg();
            this.dirOption = parser.accepts(this.getDirOption()).withRequiredArg();
            this.passwordOption = parser.accepts(this.getPasswordOption()).withOptionalArg();
            this.phraseOption = parser.accepts(this.getPhraseOption()).withOptionalArg();
            this.keyFileOption = (OptionSpec)parser.accepts(this.getKeyfileOption()).withRequiredArg().ofType(File.class);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getKeyfileOption() {
        try {
            return "keyfile";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getPhraseOption() {
        try {
            return "phrase";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getPasswordOption() {
        try {
            return "password";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getDirOption() {
        try {
            return "dir";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getArchiveOption() {
        try {
            return "archive";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Command getDelegate() {
        try {
            return this.delegate;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpec access$0(ScpCommand arg0) {
        try {
            return arg0.archiveOption;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpec access$1(ScpCommand arg0) {
        try {
            return arg0.dirOption;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpec access$2(ScpCommand arg0) {
        try {
            return arg0.keyFileOption;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpec access$3(ScpCommand arg0) {
        try {
            return arg0.phraseOption;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ StandardProject access$4(ScpCommand arg0) {
        try {
            return arg0.project;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpec access$5(ScpCommand arg0) {
        try {
            return arg0.passwordOption;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private final class Body
    implements Runnable {
        private Body() {
            try {
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }

        public void run() {
            try {
                Command delegate = ScpCommand.this.getDelegate();
                OptionSet options = delegate.getOptions();
                if (!options.has(ScpCommand.access$0(ScpCommand.this))) {
                    delegate.throwBadOptionsException("please specify the name of an archive");
                }
                if (!options.has(ScpCommand.access$1(ScpCommand.this))) {
                    delegate.throwBadOptionsException("please specify a dir option");
                }
                String archive = (String)options.valueOf(ScpCommand.access$0(ScpCommand.this));
                String dir = (String)options.valueOf(ScpCommand.access$1(ScpCommand.this));
                if (options.has(ScpCommand.access$2(ScpCommand.this))) {
                    String phrase = options.has(ScpCommand.access$3(ScpCommand.this)) ? (String)options.valueOf(ScpCommand.access$3(ScpCommand.this)) : "";
                    File keyFile = (File)options.valueOf(ScpCommand.access$2(ScpCommand.this));
                    ScpCommand.access$4(ScpCommand.this).getScpFeature().copyClasses(archive, dir, phrase, keyFile);
                } else {
                    String password = options.has(ScpCommand.access$5(ScpCommand.this)) ? (String)options.valueOf(ScpCommand.access$5(ScpCommand.this)) : "";
                    ScpCommand.access$4(ScpCommand.this).getScpFeature().copyClasses(archive, dir, password);
                }
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }
    }
}

