/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.command;

import java.io.File;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.aspectj.lang.SoftException;
import protoj.lang.Command;
import protoj.lang.CommandStore;
import protoj.lang.ScpconfFeature;
import protoj.lang.StandardProject;

public final class ScpconfCommand {
    private Command delegate;
    private OptionSpec<?> interpolateOption;
    private OptionSpec<?> cleanOption;
    private OptionSpec<String> passtextOption;
    private OptionSpec<File> keyfileOption;
    private final StandardProject project;
    private OptionSpec<String> nameOption;

    public ScpconfCommand(StandardProject project) {
        try {
            this.project = project;
            CommandStore store = project.getCommandStore();
            this.delegate = store.addCommand("scpconf", "32m", new Body());
            this.delegate.initHelpResource("/protoj-common/language/english/scpconf.txt");
            this.delegate.initBootstrapCurrentVm();
            this.nameOption = this.delegate.getParser().accepts(this.getNameOption()).withRequiredArg();
            this.interpolateOption = this.delegate.getParser().accepts(this.getInterpolateOption());
            this.cleanOption = this.delegate.getParser().accepts(this.getCleanOption());
            this.passtextOption = this.delegate.getParser().accepts(this.getPasstextOption()).withRequiredArg();
            this.keyfileOption = (OptionSpec)this.delegate.getParser().accepts(this.getKeyfileOption()).withRequiredArg().ofType(File.class);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getNameOption() {
        try {
            return "name";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getInterpolateOption() {
        try {
            return "interpolate";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getCleanOption() {
        try {
            return "clean";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getPasstextOption() {
        try {
            return "passtext";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getKeyfileOption() {
        try {
            return "keyfile";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Command getDelegate() {
        try {
            return this.delegate;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpec access$0(ScpconfCommand arg0) {
        try {
            return arg0.nameOption;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpec access$1(ScpconfCommand arg0) {
        try {
            return arg0.keyfileOption;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpec access$2(ScpconfCommand arg0) {
        try {
            return arg0.passtextOption;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpec access$3(ScpconfCommand arg0) {
        try {
            return arg0.interpolateOption;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ StandardProject access$4(ScpconfCommand arg0) {
        try {
            return arg0.project;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpec access$5(ScpconfCommand arg0) {
        try {
            return arg0.cleanOption;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public final class Body
    implements Runnable {
        public Body() {
            try {
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }

        public void run() {
            try {
                Command delegate = ScpconfCommand.this.getDelegate();
                OptionSet options = delegate.getOptions();
                if (!options.has(ScpconfCommand.access$0(ScpconfCommand.this))) {
                    String hint = "the name option is mandatory";
                    delegate.throwBadOptionsException(hint);
                }
                String name = (String)options.valueOf(ScpconfCommand.access$0(ScpconfCommand.this));
                File keyfile = (File)options.valueOf(ScpconfCommand.access$1(ScpconfCommand.this));
                String passtext = (String)options.valueOf(ScpconfCommand.access$2(ScpconfCommand.this));
                boolean interpolate = options.has(ScpconfCommand.access$3(ScpconfCommand.this));
                ScpconfFeature feature = ScpconfCommand.access$4(ScpconfCommand.this).getScpconfFeature();
                if (options.has(ScpconfCommand.access$5(ScpconfCommand.this))) {
                    feature.clean(name, keyfile, passtext);
                } else {
                    feature.configure(name, interpolate, keyfile, passtext);
                }
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }
    }
}

