/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.command;

import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.aspectj.lang.SoftException;
import protoj.lang.Command;
import protoj.lang.CommandStore;
import protoj.lang.StandardProject;

public final class TarCommand {
    private Command delegate;
    private OptionSpec<?> nosrc;
    private OptionSpec<?> rwx;
    private final StandardProject project;

    public TarCommand(StandardProject project) {
        try {
            this.project = project;
            CommandStore store = project.getCommandStore();
            this.delegate = store.addCommand("tar", "16m", new Body());
            this.delegate.initHelpResource("/protoj-common/language/english/tar.txt");
            this.delegate.initAliases("gtar", "package");
            this.nosrc = this.delegate.getParser().accepts(this.getNosrcOption());
            this.rwx = this.delegate.getParser().accepts(this.getRwxOption());
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getRwxOption() {
        try {
            return "rwx";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getNosrcOption() {
        try {
            return "nosrc";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Command getDelegate() {
        try {
            return this.delegate;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpec access$0(TarCommand arg0) {
        try {
            return arg0.nosrc;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpec access$1(TarCommand arg0) {
        try {
            return arg0.rwx;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ StandardProject access$2(TarCommand arg0) {
        try {
            return arg0.project;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private final class Body
    implements Runnable {
        private Body() {
            try {
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }

        public void run() {
            try {
                OptionSet options = TarCommand.this.getDelegate().getOptions();
                boolean noSrc = options.has(TarCommand.access$0(TarCommand.this));
                boolean isRwx = options.has(TarCommand.access$1(TarCommand.this));
                TarCommand.access$2(TarCommand.this).getArchiveFeature().getProjectArchive().createArchive(noSrc, true, isRwx);
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }
    }
}

