/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.internal;

import java.io.File;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.aspectj.lang.SoftException;
import protoj.lang.Instruction;
import protoj.lang.InstructionChain;
import protoj.lang.internal.InformationException;

public final class InstructionChainArgs {
    private static final String SCRIPT_NAME_OPTION = "scriptName";
    private static final String ROOT_DIR_OPTION = "rootDir";
    private InstructionChain chain;
    private String[] args;

    public InstructionChainArgs(InstructionChain chain, String[] args) {
        try {
            this.chain = chain;
            this.args = args;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initChain() {
        try {
            boolean noInitInstruction;
            String[] stringArray = this.args;
            int n = this.args.length;
            int n2 = 0;
            while (n2 < n) {
                String commandOptions;
                String arg = stringArray[n2];
                String[] parsed = arg.trim().split(" ", 2);
                String commandName = parsed[0];
                Instruction instruction = this.chain.addInstruction(commandName, commandOptions = parsed.length == 2 ? parsed[1] : null);
                if (instruction.isInitInstruction()) {
                    this.handleInitInstruction(instruction);
                } else if (instruction.isOptsInstruction()) {
                    this.handleOptsInstruction(instruction);
                }
                ++n2;
            }
            boolean bl = noInitInstruction = this.chain.getInitInstruction() == null;
            if (noInitInstruction) {
                StringBuilder noInit = new StringBuilder();
                noInit.append("missing init instruction: usually specified by the shell script.");
                throw new InformationException(noInit.toString());
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void handleInitInstruction(Instruction instruction) {
        try {
            String opts = instruction.getOpts();
            OptionParser parser = new OptionParser();
            OptionSpec rootDirOption = (OptionSpec)parser.accepts(ROOT_DIR_OPTION).withRequiredArg().ofType(File.class);
            ArgumentAcceptingOptionSpec scriptNameOption = parser.accepts(SCRIPT_NAME_OPTION).withRequiredArg();
            OptionSet options = parser.parse(opts.split(" "));
            boolean hasRootDirOption = options.has(rootDirOption);
            if (!hasRootDirOption) {
                StringBuilder noRootDir = new StringBuilder();
                noRootDir.append("missing option for init command: the ");
                noRootDir.append(rootDirOption.toString());
                noRootDir.append(" option is mandatory");
                throw new InformationException(noRootDir.toString());
            }
            boolean hasScriptOption = options.has((OptionSpec)scriptNameOption);
            if (!hasScriptOption) {
                StringBuilder noScriptName = new StringBuilder();
                noScriptName.append("missing option for init command: the ");
                noScriptName.append(scriptNameOption.toString());
                noScriptName.append(" option is mandatory");
                throw new InformationException(noScriptName.toString());
            }
            File rootDir = (File)options.valueOf(rootDirOption);
            String scriptName = (String)options.valueOf((OptionSpec)scriptNameOption);
            this.chain.init(rootDir, scriptName);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void handleOptsInstruction(Instruction instruction) {
        try {
            String opts = instruction.getOpts();
            if (!instruction.hasOpts()) {
                StringBuilder noArgs = new StringBuilder();
                noArgs.append("no -D properties given to the opt instruction: ");
                noArgs.append(instruction.getText());
                noArgs.append(" (is entire instruction surrounded with quotes?): ");
                noArgs.append(instruction.getText());
                throw new InformationException(noArgs.toString());
            }
            OptionParser parser = new OptionParser("D:");
            OptionSet options = parser.parse(opts.split(" "));
            List pairs = options.valuesOf("D");
            for (Object pair : pairs) {
                String[] parsed = ((String)pair).split("=", 2);
                String key = parsed[0];
                String value = parsed.length == 1 ? "" : parsed[1];
                System.setProperty(key, value);
                String jvmArg = "-D" + key + "=" + value;
                this.chain.addJvmArg(jvmArg);
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

