/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.internal;

import org.apache.log4j.Logger;
import org.aspectj.lang.SoftException;
import protoj.lang.DispatchFeature;
import protoj.lang.StandardProject;

public final class ProjectReporter {
    private final StandardProject parent;

    public ProjectReporter(StandardProject parent) {
        try {
            this.parent = parent;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public boolean isReportingEnabled() {
        try {
            return true;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void beginCommand(String command) {
        try {
            if (this.isReportingEnabled()) {
                this.getLogger().info((Object)"");
                this.getLogger().info((Object)this.getHighlightedMessage(command));
                this.getLogger().info((Object)"");
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void unknownCommand(String command) {
        try {
            if (this.isReportingEnabled()) {
                this.getLogger().error((Object)("unknown command: \"" + command + "\""));
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void projectSucceeded() {
        try {
            if (this.isReportingEnabled()) {
                this.getLogger().info((Object)"");
                this.getLogger().info((Object)"BUILD SUCCESSFUL");
                this.logElapsedTime();
                this.getLogger().info((Object)"");
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void projectFailed(Throwable e) {
        try {
            this.getLogger().info((Object)"");
            this.getLogger().info((Object)"BUILD FAILED", e);
            this.logElapsedTime();
            this.getLogger().info((Object)"");
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void projectFailed(String description) {
        try {
            this.getLogger().info((Object)"");
            this.getLogger().info((Object)"BUILD FAILED");
            this.getLogger().info((Object)description);
            this.logElapsedTime();
            this.getLogger().info((Object)"");
            String logPath = this.parent.getLayout().getLogFile().getAbsolutePath();
            System.err.println("BUILD FAILED - see " + logPath + " for more information");
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void logElapsedTime() {
        try {
            long seconds;
            long minutes;
            DispatchFeature feature = this.parent.getDispatchFeature();
            StringBuilder message = new StringBuilder();
            message.append("Total time: ");
            long hours = feature.getElapsedHours();
            if (hours != 0L) {
                if (hours == 1L) {
                    message.append("1 hour ");
                } else {
                    message.append(hours);
                    message.append(" hours ");
                }
            }
            if ((minutes = feature.getElapsedMinutes()) != 0L) {
                if (minutes == 1L) {
                    message.append("1 minute ");
                } else {
                    message.append(minutes);
                    message.append(" minutes ");
                }
            }
            if ((seconds = feature.getElapsedSeconds()) == 0L) {
                message.append("0 seconds");
            } else if (seconds == 1L) {
                message.append("1 second");
            } else {
                message.append(seconds);
                message.append(" seconds");
            }
            this.getLogger().info((Object)message);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getHighlightedMessage(String message) {
        try {
            return String.valueOf(message) + ":";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Logger getLogger() {
        try {
            return this.parent.getLogger();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

