/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.internal;

import java.io.File;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.aspectj.lang.SoftException;
import protoj.lang.StandardProject;
import protoj.lang.internal.ProtoExceptionHandler;
import protoj.lang.internal.ProtoProject;
import protoj.lang.internal.SampleProjectFeature;

public final class ProtoExecutableMain {
    private ArgumentAcceptingOptionSpec<String> sampleOption;
    private OptionSpecBuilder helpOption;
    private OptionParser parser;
    private OptionSet options;
    private String[] args;

    public static void main(String[] stringArray) {
        String[] stringArray2 = stringArray;
        try {
            String[] args;
            ProtoExceptionHandler.aspectOf().ajc$before$protoj_lang_internal_UncaughtExceptionPolicy$1$eb752c96(stringArray2);
            new ProtoExecutableMain(args);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ProtoExecutableMain(String[] args) {
        try {
            this.args = args;
            this.parser = new OptionParser();
            String createDescription = String.format("specify the name of a sample project to create, can be one of: %s, %s, %s, %s, %s or %s", "acme", "ajc", "alien", "basic", "helloworld", "serverdemo");
            this.sampleOption = this.parser.accepts("sample", createDescription).withRequiredArg();
            this.sampleOption.describedAs("project name");
            this.helpOption = this.parser.acceptsAll((Collection)Arrays.asList("help", "?"), "show help");
            this.options = this.parser.parse(args);
            if (this.options.has((OptionSpec)this.helpOption)) {
                this.parser.printHelpOn((OutputStream)System.out);
            } else if (this.options.has(this.sampleOption)) {
                this.createSampleProject((String)this.options.valueOf(this.sampleOption));
            } else {
                this.dispatchCommands();
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void dispatchCommands() {
        try {
            StandardProject standardProject = new StandardProject(this.args, null);
            standardProject.getDispatchFeature().dispatchCommands();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void createSampleProject(String projectName) {
        try {
            ProtoProject project = new ProtoProject(new File("."), "unspecified", null);
            SampleProjectFeature feature = project.getSampleProjectFeature();
            if (projectName.equals("basic")) {
                feature.createBasicProject(new File("."));
            } else if (projectName.equals("acme")) {
                feature.createAcmeProject(new File("."));
            } else if (projectName.equals("ajc")) {
                feature.createAjcProject(new File("."));
            } else if (projectName.equals("alien")) {
                feature.createAlienProject(new File("."));
            } else if (projectName.equals("helloworld")) {
                feature.createHelloWorldProject(new File("."));
            } else if (projectName.equals("serverdemo")) {
                feature.createServerDemoProject(new File("."));
            } else {
                System.out.println("unrecognized project name: " + projectName);
                this.parser.printHelpOn((OutputStream)System.out);
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

