/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Java;
import org.aspectj.lang.SoftException;
import protoj.lang.ArchiveFeature;
import protoj.lang.ClassesArchive;
import protoj.lang.DependencyInfo;
import protoj.lang.DependencyStore;
import protoj.lang.JavadocArchive;
import protoj.lang.ProjectLayout;
import protoj.lang.ResourceFeature;
import protoj.lang.SourceArchive;
import protoj.lang.StandardProject;
import protoj.lang.command.ArchiveCommand;
import protoj.lang.command.PublishCommand;
import protoj.lang.internal.DocsCommand;
import protoj.lang.internal.ProtoExceptionHandler;
import protoj.lang.internal.ProtoExecutableMain;
import protoj.lang.internal.ProtoconfCommand;
import protoj.lang.internal.ReleaseCommand;
import protoj.lang.internal.ReleaseFeature;
import protoj.lang.internal.SampleProjectFeature;
import protoj.util.AntTarget;
import protoj.util.ArgRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProtoProject {
    private StandardProject delegate;
    private ReleaseCommand releaseCommand;
    private ProtoconfCommand protoconfCommand;
    private ReleaseFeature releaseFeature;
    private SampleProjectFeature sampleProjectFeature;
    private DocsCommand siteCommand;
    private ArrayList<DependencyInfo> strictRepoDependencies;
    private ArrayList<DependencyInfo> strictDependencies;

    public static void main(String[] stringArray) {
        String[] stringArray2 = stringArray;
        try {
            String[] args;
            ProtoExceptionHandler.aspectOf().ajc$before$protoj_lang_internal_UncaughtExceptionPolicy$1$eb752c96(stringArray2);
            new ProtoProject(args).dispatchCommands();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ProtoProject() {
        try {
            this.init(new StandardProject(null));
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ProtoProject(String[] args) {
        try {
            this.init(new StandardProject(args, null));
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ProtoProject(File rootDir, String script, String versionInfo) {
        try {
            this.init(new StandardProject(rootDir, script, versionInfo));
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void init(StandardProject project) {
        try {
            this.delegate = project;
            this.releaseFeature = new ReleaseFeature(this);
            this.sampleProjectFeature = new SampleProjectFeature(this);
            project.initDirConfig(this.getProjectHome());
            project.getResourceFeature().getContext().put("protoProject", (Object)this);
            project.getRetrieveFeature().initIvy("/protoj-dev/ivy.xml");
            this.initStrictDependencies();
            this.initStrictRepoDependencies();
            this.initProtoExeJar();
            this.initProtoJar();
            this.delegate.initJunit("32m");
            this.delegate.initUploadGoogleCode("protoj");
            this.delegate.initPublish("scp://shell.sourceforge.net:/home/groups/p/pr/protojrepo/htdocs/mavensync");
            this.delegate.getPublishFeature().initProvider("wagon-ssh", "1.0-beta-2");
            PublishCommand publishCommand = this.delegate.getCommands().getPublish();
            publishCommand.getDelegate().setMemory("32m");
            ArchiveCommand archiveCommand = this.delegate.getCommands().getArchive();
            archiveCommand.getDelegate().setMemory("32m");
            this.releaseCommand = new ReleaseCommand(this, this.getClass().getName());
            this.protoconfCommand = new ProtoconfCommand(this);
            this.siteCommand = new DocsCommand(this);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void initStrictDependencies() {
        try {
            DependencyStore store = this.delegate.getDependencyStore();
            this.strictDependencies = new ArrayList();
            this.strictDependencies.addAll(store.getDependencies());
            this.strictDependencies.remove(store.getProtoj());
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void initStrictRepoDependencies() {
        try {
            DependencyStore store = this.delegate.getDependencyStore();
            this.strictRepoDependencies = new ArrayList();
            this.strictRepoDependencies.addAll(store.getRepoDependencies());
            this.strictRepoDependencies.remove(store.getProtoj());
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void initProtoExeJar() {
        try {
            final String projectVersion = this.getVersion();
            ClassesArchive classes = this.delegate.getArchiveFeature().getClassesArchive();
            String jarName = this.getVersionedExeJarTag();
            classes.addEntry(jarName, "MANIFEST", "protoj/**/* protoj-common/**/* protoj-exe/**/*", null);
            classes.getEntry(jarName).initConfig(new ArgRunnable<ClassesArchive>(){
                {
                    try {
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }

                @Override
                public void run(ClassesArchive archive) {
                    try {
                        archive.getCurrentAssembleTask().initManifest("ProtoJ-Version", projectVersion);
                        archive.initExecutableJar(ProtoExecutableMain.class.getName());
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }
            });
            classes.initExcludeArchives(jarName, "aspectjtools.jar");
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void initProtoJar() {
        try {
            final String projectVersion = this.getVersion();
            ClassesArchive classes = this.delegate.getArchiveFeature().getClassesArchive();
            String jarName = this.getVersionedJarTag();
            classes.addEntry(jarName, "MANIFEST", "protoj/**/* protoj-common/**/*", null);
            classes.initClasspathLib(jarName);
            classes.getEntry(jarName).initConfig(new ArgRunnable<ClassesArchive>(){
                {
                    try {
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }

                @Override
                public void run(ClassesArchive archive) {
                    try {
                        archive.getCurrentAssembleTask().initManifest("ProtoJ-Version", projectVersion);
                        archive.initExecutableJar(ProtoExecutableMain.class.getName());
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }
            });
            String pomName = "/protoj-dev/pom.publish.xml";
            classes.initPublish(jarName, pomName, this.getGpgOptions());
            SourceArchive source = this.delegate.getArchiveFeature().getSourceArchive();
            source.addEntry(jarName, null, null, null);
            source.getEntry(jarName).initConfig(new ArgRunnable<SourceArchive>(){
                {
                    try {
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }

                @Override
                public void run(SourceArchive archive) {
                    try {
                        archive.getCurrentAssembleTask().initManifest("ProtoJ-Version", projectVersion);
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }
            });
            JavadocArchive archive = this.delegate.getArchiveFeature().getJavadocArchive();
            archive.addEntry(jarName, null, null, null, "16m");
            archive.getEntry(jarName).initConfig(new ArgRunnable<JavadocArchive>(){
                {
                    try {
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }

                @Override
                public void run(JavadocArchive archive) {
                    try {
                        archive.getCurrentAssembleTask().initManifest("ProtoJ-Version", projectVersion);
                        archive.getJavadocTask().getjavadoc().setLinksource(true);
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }
            });
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private String getGpgOptions() {
        try {
            return "--armor --local-user agwilliams1000 --output %2$s --detach-sign %1$s";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public StandardProject createServerDemoProjectDelegate() {
        try {
            StandardProject demoDelegate = this.createSampleProject("serverdemo");
            File thisSrcDir = this.delegate.getLayout().getSrcDir();
            File demoSrcDir = demoDelegate.getLayout().getSrcDir();
            File jboss5 = new File(thisSrcDir, "jboss-5.0.1.GA.zip");
            FileUtils.copyFileToDirectory((File)jboss5, (File)demoSrcDir);
            File jboss6 = new File(thisSrcDir, "jboss-5.0.1.GA-jdk6.zip");
            FileUtils.copyFileToDirectory((File)jboss6, (File)demoSrcDir);
            return demoDelegate;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public StandardProject createSampleProject(String projectName) {
        try {
            this.createClassesArchives();
            AntTarget target = new AntTarget("sample");
            ProjectLayout layout = this.delegate.getLayout();
            target.initLogging(2);
            Java java = new Java();
            target.addTask((Task)java);
            java.setTaskName("sample-java");
            java.setJar(this.getExeFile());
            java.createArg().setValue("-sample");
            java.createArg().setValue(projectName);
            java.setFork(true);
            java.setFailonerror(true);
            java.setDir(layout.getTargetDir());
            target.execute();
            File rootDir = new File(layout.getTargetDir(), projectName);
            return new StandardProject(rootDir, projectName, null);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getExeFile() {
        try {
            ArchiveFeature feature = this.getDelegate().getArchiveFeature();
            ClassesArchive classes = feature.getClassesArchive();
            ClassesArchive.ClassesEntry entry = classes.getEntry(this.getVersionedExeJarTag());
            return entry.getArchiveEntry().getArtifact();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void extractSite() {
        try {
            File rootDir = this.delegate.getLayout().getRootDir();
            File wikiDir = new File(rootDir.getParentFile(), "wiki");
            if (!wikiDir.exists()) {
                String message = "checked out wiki directory is required: " + wikiDir.getAbsolutePath();
                throw new RuntimeException(message);
            }
            ResourceFeature feature = this.getDelegate().getResourceFeature();
            File targetDir = this.getDelegate().getLayout().getTargetDir();
            File siteDir = new File(targetDir, "google-site");
            feature.filterResourceToDir("/protoj-dev/site/project-summary.wiki", siteDir);
            feature.filterResourceToDir("/protoj-dev/site/wiki/AlternativeProjects.wiki", siteDir);
            feature.filterResourceToDir("/protoj-dev/site/wiki/BasicConcepts.wiki", siteDir);
            feature.filterResourceToDir("/protoj-dev/site/wiki/BuildingFromSource.wiki", siteDir);
            feature.filterResourceToDir("/protoj-dev/site/wiki/CommandSetup.wiki", siteDir);
            feature.filterResourceToDir("/protoj-dev/site/wiki/Sidebar.wiki", siteDir);
            feature.filterResourceToDir("/protoj-dev/site/wiki/UseCaseCompile.wiki", siteDir);
            feature.filterResourceToDir("/protoj-dev/site/wiki/UseCaseProfile.wiki", siteDir);
            feature.filterResourceToDir("/protoj-dev/site/wiki/UseCaseDebug.wiki", siteDir);
            feature.filterResourceToDir("/protoj-dev/site/wiki/UseCaseDependencies.wiki", siteDir);
            feature.filterResourceToDir("/protoj-dev/site/wiki/UseCaseDeploy.wiki", siteDir);
            feature.filterResourceToDir("/protoj-dev/site/wiki/UseCaseHelp.wiki", siteDir);
            feature.filterResourceToDir("/protoj-dev/site/wiki/UseCaseLog.wiki", siteDir);
            feature.filterResourceToDir("/protoj-dev/site/wiki/UseCasePackage.wiki", siteDir);
            feature.filterResourceToDir("/protoj-dev/site/wiki/UseCaseUploadMavenRepo.wiki", siteDir);
            feature.filterResourceToDir("/protoj-dev/site/wiki/UseCaseUploadGoogleCode.wiki", siteDir);
            feature.filterResourceToDir("/protoj-dev/site/wiki/UseCaseProfile.wiki", siteDir);
            feature.filterResourceToDir("/protoj-dev/site/wiki/UseCasePackageRelationships.wiki", siteDir);
            feature.filterResourceToDir("/protoj-dev/site/wiki/UseCaseSpecifyProperties.wiki", siteDir);
            feature.filterResourceToDir("/protoj-dev/site/wiki/UseCaseTest.wiki", siteDir);
            feature.filterResourceToDir("/protoj-dev/site/wiki/DemoJbossProject.wiki", siteDir);
            feature.filterResourceToDir("/protoj-dev/site/wiki/DemoAlienProject.wiki", siteDir);
            feature.filterResourceToDir("/protoj-dev/site/wiki/DemoBasicProject.wiki", siteDir);
            feature.filterResourceToDir("/protoj-dev/site/wiki/DemoHelloWorldProject.wiki", siteDir);
            File srcDir = new File(siteDir, "protoj-dev/site/wiki");
            FileUtils.copyDirectory((File)srcDir, (File)wikiDir);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void extractJavadocs() {
        try {
            File dest = new File(this.delegate.getLayout().getDocsDir(), "api");
            if (dest.exists()) {
                String message = "first delete the javadoc directory from source control: " + dest.getAbsolutePath();
                throw new RuntimeException(message);
            }
            dest.mkdir();
            ArchiveFeature feature = this.getDelegate().getArchiveFeature();
            JavadocArchive archive = feature.getJavadocArchive();
            JavadocArchive.JavadocEntry entry = archive.getEntry(this.getVersionedJarTag());
            File javadocJar = entry.getArchiveEntry().getArtifact();
            AntTarget target = new AntTarget("serverdemo-project");
            target.initLogging(2);
            Expand expand = new Expand();
            target.addTask((Task)expand);
            expand.setTaskName("expand");
            expand.setSrc(javadocJar);
            expand.setDest(dest);
            target.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void createAllArchives() {
        try {
            this.createClassesArchives();
            this.createInfoArchives();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void createClassesArchives() {
        try {
            ArchiveFeature archive = this.delegate.getArchiveFeature();
            archive.getClassesArchive().createArchive(this.getVersionedJarTag());
            File srcDir = this.delegate.getLayout().getLibDir();
            File destDir = new File(this.delegate.getLayout().getClassesDir(), "protoj-exe/common/lib");
            destDir.mkdirs();
            DependencyStore store = this.delegate.getDependencyStore();
            Collection<DependencyInfo> infos = store.getDependencies();
            for (DependencyInfo info : infos) {
                String jarName = info.getJarName();
                File srcFile = new File(srcDir, jarName);
                FileUtils.copyFileToDirectory((File)srcFile, (File)destDir);
            }
            archive.getClassesArchive().createArchive(this.getVersionedExeJarTag());
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void createInfoArchives() {
        try {
            ArchiveFeature archive = this.delegate.getArchiveFeature();
            archive.getJavadocArchive().createArchive(this.getVersionedJarTag());
            archive.getSourceArchive().createArchive(this.getVersionedJarTag());
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void configureDefault() {
        try {
            this.delegate.getDirconfFeature().clean("default");
            this.delegate.getDirconfFeature().configure("default", false);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void dispatchCommands() {
        try {
            this.delegate.getDispatchFeature().dispatchCommands();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ReleaseCommand getReleaseCommand() {
        try {
            return this.releaseCommand;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ProtoconfCommand getProtoconfCommand() {
        try {
            return this.protoconfCommand;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DocsCommand getSiteCommand() {
        try {
            return this.siteCommand;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ReleaseFeature getReleaseFeature() {
        try {
            return this.releaseFeature;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public SampleProjectFeature getSampleProjectFeature() {
        try {
            return this.sampleProjectFeature;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public StandardProject getDelegate() {
        try {
            return this.delegate;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getVersionedJarTag() {
        try {
            return String.valueOf(this.getProtoArtifact().getArtifactId()) + "-" + this.getProtoArtifact().getVersion();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getJarName() {
        try {
            return this.getProtoArtifact().getVersionedJarName();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getVersion() {
        try {
            return this.getProtoArtifact().getVersion();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getVersionedExeJarTag() {
        try {
            return String.valueOf(this.getExeJarTag()) + "-" + this.getVersion();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getExeJarTag() {
        try {
            String tag = this.delegate.isJdk6() ? "protoj-exe-jdk6" : "protoj-exe-jdk5";
            return tag;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getExeJarName() {
        try {
            return String.valueOf(this.getVersionedExeJarTag()) + ".jar";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getProjectHome() {
        try {
            String userHome = System.getProperty("user.home");
            return new File(userHome, ".protoj");
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getCentralRepositoryUrl() {
        try {
            return "http://repo1.maven.org/maven2/com/google/code/protoj/";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getProjectUrl() {
        try {
            return "http://code.google.com/p/protoj/" + this.getVersion();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getBrowsableUrl() {
        try {
            return "http://code.google.com/p/protoj/source/browse/" + this.getVersion();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getDownloadUr() {
        try {
            return "http://protoj.googlecode.com/files";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getExeDownloadUrl() {
        try {
            return String.valueOf(this.getDownloadUr()) + "/" + this.getExeJarName();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DependencyInfo getProtoArtifact() {
        try {
            return this.delegate.getDependencyStore().getProtoj();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ArrayList<DependencyInfo> getStrictDependencies() {
        try {
            return this.strictDependencies;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ArrayList<DependencyInfo> getStrictRepoDependencies() {
        try {
            return this.strictRepoDependencies;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

