/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.internal;

import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.aspectj.lang.SoftException;
import protoj.lang.Command;
import protoj.lang.CommandStore;
import protoj.lang.internal.ProtoProject;

public final class ReleaseCommand {
    private Command delegate;
    private OptionSpec<String> gcUserOption;
    private OptionSpec<String> gcPasswordOption;
    private OptionSpec<String> sfUserOption;
    private OptionSpecBuilder gcOnlyOption;
    private OptionSpecBuilder sfOnlyOption;

    public ReleaseCommand(ProtoProject project, String mainClass) {
        try {
            CommandStore store = project.getDelegate().getCommandStore();
            this.delegate = store.addCommand("release", "64m", new Body(project));
            this.delegate.initHelpResource("/protoj-common/language/english/release.txt");
            OptionParser parser = this.delegate.getParser();
            this.gcUserOption = parser.accepts(this.getGcuserOption()).withRequiredArg();
            this.gcPasswordOption = parser.accepts(this.getGcpasswordOption()).withRequiredArg();
            this.sfUserOption = parser.accepts(this.getSfuserOption()).withRequiredArg();
            this.gcOnlyOption = parser.accepts(this.getGconlyOption());
            this.sfOnlyOption = parser.accepts(this.getSfonlyOption());
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getSfonlyOption() {
        try {
            return "sfonly";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getGconlyOption() {
        try {
            return "gconly";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getSfuserOption() {
        try {
            return "sfuser";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getGcpasswordOption() {
        try {
            return "gcpassword";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getGcuserOption() {
        try {
            return "gcuser";
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Command getDelegate() {
        try {
            return this.delegate;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ Command access$0(ReleaseCommand arg0) {
        try {
            return arg0.delegate;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpec access$1(ReleaseCommand arg0) {
        try {
            return arg0.gcUserOption;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpec access$2(ReleaseCommand arg0) {
        try {
            return arg0.gcPasswordOption;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpec access$3(ReleaseCommand arg0) {
        try {
            return arg0.sfUserOption;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpecBuilder access$4(ReleaseCommand arg0) {
        try {
            return arg0.gcOnlyOption;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ OptionSpecBuilder access$5(ReleaseCommand arg0) {
        try {
            return arg0.sfOnlyOption;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private final class Body
    implements Runnable {
        private final ProtoProject project;

        private Body(ProtoProject project) {
            try {
                this.project = project;
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }

        public void run() {
            try {
                String message;
                OptionSet options = ReleaseCommand.access$0(ReleaseCommand.this).getOptions();
                if (!options.has(ReleaseCommand.access$1(ReleaseCommand.this))) {
                    message = "incorrect arguments: the release command requires a googlecode username";
                    ReleaseCommand.access$0(ReleaseCommand.this).throwBadOptionsException(message);
                }
                if (!options.has(ReleaseCommand.access$2(ReleaseCommand.this))) {
                    message = "incorrect arguments: the release command requires a googlecode password";
                    ReleaseCommand.access$0(ReleaseCommand.this).throwBadOptionsException(message);
                }
                if (!options.has(ReleaseCommand.access$3(ReleaseCommand.this))) {
                    message = "incorrect arguments: the release command requires a sourceforge username";
                    ReleaseCommand.access$0(ReleaseCommand.this).throwBadOptionsException(message);
                }
                String gcUser = (String)options.valueOf(ReleaseCommand.access$1(ReleaseCommand.this));
                String gcPassword = (String)options.valueOf(ReleaseCommand.access$2(ReleaseCommand.this));
                String sfUser = (String)options.valueOf(ReleaseCommand.access$3(ReleaseCommand.this));
                if (options.has((OptionSpec)ReleaseCommand.access$4(ReleaseCommand.this))) {
                    this.project.getReleaseFeature().uploadToGoogleCode(gcUser, gcPassword);
                } else if (options.has((OptionSpec)ReleaseCommand.access$5(ReleaseCommand.this))) {
                    this.project.getReleaseFeature().uploadToMaven(sfUser);
                } else {
                    this.project.getReleaseFeature().release(gcUser, gcPassword, sfUser);
                }
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }
    }
}

