/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.internal;

import java.io.File;
import org.aspectj.lang.SoftException;
import protoj.lang.ArchiveEntry;
import protoj.lang.ArchiveFeature;
import protoj.lang.ClassesArchive;
import protoj.lang.PropertyInfo;
import protoj.lang.PublishFeature;
import protoj.lang.StandardProject;
import protoj.lang.internal.ProtoProject;

public final class ReleaseFeature {
    private final ProtoProject project;

    public ReleaseFeature(ProtoProject project) {
        try {
            this.project = project;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void release(String gcUserName, String gcPassword, String sfUserName) {
        try {
            this.showSummary();
            this.createDocs();
            this.project.createAllArchives();
            this.uploadToMaven(sfUserName);
            this.uploadToGoogleCode(gcUserName, gcPassword);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void createDocs() {
        try {
            boolean isJava5;
            boolean bl = isJava5 = !this.project.getDelegate().isJdk6();
            if (isJava5) {
                this.project.extractJavadocs();
                this.project.extractSite();
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void uploadToMaven(String sfUserName) {
        try {
            PublishFeature publishFeature = this.project.getDelegate().getPublishFeature();
            publishFeature.deployAll(sfUserName, null, null, null);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void uploadToGoogleCode(String gcUserName, String gcPassword) {
        try {
            StandardProject delegate = this.project.getDelegate();
            ArchiveFeature archive = delegate.getArchiveFeature();
            ClassesArchive classes = archive.getClassesArchive();
            ArchiveEntry<ClassesArchive> entry = classes.getEntry(this.project.getVersionedExeJarTag()).getArchiveEntry();
            String googleName = String.format("%s-%s.jar", entry.getName(), this.project.getVersion());
            File artifact = entry.getArtifact();
            delegate.getUploadGoogleCodeFeature().uploadArtifact(artifact, googleName, "Type-Archive, OpSys-All, Featured", "executable jar file, execute with --help", gcUserName, gcPassword);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void showSummary() {
        try {
            StandardProject delegate = this.project.getDelegate();
            PropertyInfo gcskip = delegate.getProperties().getGcskip();
            StringBuilder builder = new StringBuilder();
            if (gcskip.getBooleanValue()) {
                builder.append("ProtoJ won't be uploaded to google code during this release.");
            } else {
                builder.append("ProtoJ will be uploaded to google code during this release.");
            }
            builder.append(" See the help for ");
            builder.append(gcskip.getKey());
            builder.append(" for more information.");
            delegate.getLogger().info((Object)builder.toString());
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

