/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.aspectj.lang.SoftException;
import protoj.lang.DependencyInfo;
import protoj.lang.DependencyStore;
import protoj.lang.ProjectLayout;
import protoj.lang.StandardProject;
import protoj.lang.internal.ProtoProject;

public final class SampleProjectFeature {
    private ProjectLayout layout;
    private final ProtoProject parent;

    public SampleProjectFeature(ProtoProject parent) {
        try {
            this.parent = parent;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void createBasicProject(File parentDir) {
        try {
            this.createProject(parentDir, "basic", "bin/basic.sh", "bin/basic.bat", "src/resources/basic/ivy.xml", "conf/profile/conf/basic.properties", "conf/dev.properties", "README.txt", "NOTICE.txt", "src/java/org/basic/core/BasicCore.java", "src/java/org/basic/system/BasicProject.java");
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void createAjcProject(File parentDir) {
        try {
            this.createProject(parentDir, "ajc", "bin/ajc.sh", "bin/ajc.bat", "src/resources/ajc/ivy.xml", "src/resources/META-INF/aop.xml", "conf/profile/conf/ajc.properties", "conf/dev.properties", "README.txt", "NOTICE.txt", "src/java/org/ajc/core/AjcCore.java", "src/java/org/ajc/system/AjcProject.java", "src/java/org/ajc/system/AjcTrace.aj", "src/java/org/ajc/system/SoftException.aj");
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void createAcmeProject(File parentDir) {
        try {
            this.createProject(parentDir, "acme", "all-private/red.txt", "bin/acme.sh", "bin/acme.bat", "conf/profile/conf/acme.properties", "conf/profile/conf/configa.properties", "conf/profile/conf/configb.properties", "conf/profile/docs/sample.properties", "conf/profile/docs/sample.txt", "conf/all.project.properties", "log/acme.log", "part-private/amber.txt", "part-private/green.txt", "src/java/acme/core/AcmeCore.java", "src/java/acme/util/AcmeUtil.java", "src/java/acme/AcmeProject.java", "src/java/acme/AssemblyTrace.aj", "src/java/acme/FakeSignature.aj", "src/java/acme/SampleTest.java", "src/java/acme/SoftException.aj", "src/manifest/foo-manifest.MF", "src/resources/acme/acme-publish.xml", "src/resources/acme/foo-publish.xml", "src/resources/acme/ivy.xml", "src/resources/META-INF/aop.xml", "src/resources/test.txt", "README.txt", "NOTICE.txt");
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void createHelloWorldProject(File parentDir) {
        try {
            this.createProject(parentDir, "helloworld", "bin/helloworld.sh", "bin/helloworld.bat", "conf/helloworld.properties", "conf/profile/conf/helloworld.properties", "src/java/helloworld/HelloWorld.java", "README.txt", "NOTICE.txt");
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void createAlienProject(File parentDir) {
        try {
            this.createProject(parentDir, "alien", "bin/alien.sh", "bin/alien.bat", "conf/alien.test.properties", "conf/profile/conf/alien.properties", "conf/profile/conf/alien.test.properties", "conf/profile/docs/topsecret.txt", "conf/profile/conf/alien.properties", "src/java/alien/core/AlienCore.java", "src/java/alien/test/AlienTest.java", "src/java/alien/AlienProject.java", "src/resources/alien/ivy.xml", "README.txt", "NOTICE.txt");
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void createServerDemoProject(File parentDir) {
        try {
            this.createProject(parentDir, "serverdemo", "bin/serverdemo.sh", "bin/serverdemo.bat", "conf/profile/conf/jboss.opts.properties", "conf/profile/conf/jboss.bindings.properties", "conf/profile/conf/serverdemo.properties", "conf/profile/jboss-5.0.1.GA/server/default/conf/bootstrap/bindings.xml", "src/java/org/serverdemo/core/ServerDemoCore.java", "src/java/org/serverdemo/system/ServerDemoProject.java", "src/java/org/serverdemo/system/JbossWatcher.aj", "src/java/org/serverdemo/system/SoftException.aj", "src/resources/META-INF/aop.xml", "src/resources/org/serverdemo/ivy.xml", "README.txt", "src/resources/org/serverdemo/jboss/server/default/conf/jboss-service.xml", "src/resources/org/serverdemo/jboss/server/default/deploy/properties-service.xml", "NOTICE.txt");
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void createProject(File parentDir, String projectName, String ... relResourceNames) {
        try {
            File rootDir = new File(parentDir, projectName);
            StandardProject project = new StandardProject(rootDir, projectName, null);
            this.layout = project.getLayout();
            this.layout.createPhysicalLayout();
            this.copyResource("common", "conf/profile/conf/app.properties");
            DependencyStore store = this.parent.getDelegate().getDependencyStore();
            Collection<DependencyInfo> infos = store.getDependencies();
            for (DependencyInfo info : infos) {
                String jarName = info.getJarName();
                this.copyResource("common", "lib/" + jarName);
            }
            String[] stringArray = relResourceNames;
            int n = relResourceNames.length;
            int n2 = 0;
            while (n2 < n) {
                String relResourceName = stringArray[n2];
                this.copyResource(this.layout.getRootName(), relResourceName);
                ++n2;
            }
            this.layout.relaxPermissions();
            System.out.println("created project at " + this.layout.getRootDir().getCanonicalPath());
            System.out.println("please check the README.txt file");
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void copyResource(String resParent, String resName) {
        try {
            String resourceName = "/protoj-exe/" + resParent + "/" + resName;
            InputStream in = this.getClass().getResourceAsStream(resourceName);
            if (in == null) {
                throw new RuntimeException("couldn't find resource " + resourceName);
            }
            File dest = new File(this.layout.getRootDir(), resName);
            dest.getParentFile().mkdirs();
            dest.createNewFile();
            try {
                FileOutputStream out = new FileOutputStream(dest);
                try {
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)out);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

