/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.internal;

import java.awt.GraphicsEnvironment;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.Logger;
import org.aspectj.lang.SoftException;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import protoj.lang.ProtoLogger;
import protoj.lang.internal.MessageFrame;

@Aspect
public abstract class UncaughtExceptionPolicy
implements Thread.UncaughtExceptionHandler {
    private boolean exceptionWindow;
    private Logger logger;

    @Pointcut(value="", argNames="")
    public abstract /* synthetic */ void ajc$pointcut$$mainCodebase$668();

    @Before(value="(execution(* main(String)) && (args(mainArgs) && mainCodebase()))", argNames="mainArgs")
    public void ajc$before$protoj_lang_internal_UncaughtExceptionPolicy$1$eb752c96(String[] mainArgs) {
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    @AfterReturning(pointcut="(execution(ProtoLogger.new(..)) && this(logger))", returning="", argNames="logger")
    public void ajc$afterReturning$protoj_lang_internal_UncaughtExceptionPolicy$2$b2b20224(ProtoLogger logger) {
        this.logger = logger.getProtoLogger();
    }

    public UncaughtExceptionPolicy() {
        try {
            this.exceptionWindow = false;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void setExceptionWindow(boolean exceptionWindow) {
        try {
            this.exceptionWindow = exceptionWindow;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public boolean isExceptionWindow() {
        try {
            return this.exceptionWindow;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void uncaughtException(Thread t, Throwable e) {
        try {
            try {
                StringBuilder report;
                if (this.isExceptionWindow()) {
                    if (GraphicsEnvironment.isHeadless()) {
                        StringBuilder message = new StringBuilder("\ncan't show the exception in a window when in a headless environment");
                        this.logger.error((Object)message);
                        System.err.println(message.toString());
                    } else {
                        report = this.createExceptionReport(e);
                        MessageFrame messageFrame = new MessageFrame();
                        messageFrame.setTitle("Error Report");
                        messageFrame.setDefaultCloseOperation(2);
                        messageFrame.pack();
                        messageFrame.getMessageContainer().setText(report.toString());
                        messageFrame.setVisible(true);
                    }
                }
                report = new StringBuilder();
                report.append("\n\n\n\n\n");
                report.append((CharSequence)this.createExceptionReport(e));
                report.append("\n\n\n\n\n");
                System.err.println(report);
                this.logger.error((Object)report);
            }
            catch (Throwable th) {
                e.printStackTrace();
                th.printStackTrace();
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private StringBuilder createExceptionReport(Throwable e) {
        try {
            StringBuilder report = new StringBuilder();
            report.append("An application fault has been detected.\n");
            report.append("It may be possible to continue using it, but doing so may result in further problems.\n");
            report.append("Here is the cause of the fault:\n");
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            try {
                e.printStackTrace(printWriter);
            }
            finally {
                printWriter.close();
            }
            report.append(stringWriter.getBuffer());
            return report;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

