/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.aspectj.lang.SoftException;
import org.junit.Assert;

public final class VerifyArchive {
    private final File archive;
    private String[] includedResources;
    private String[] excludedResources;
    private Manifest manifest;

    public VerifyArchive(File archive) {
        try {
            this.archive = archive;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initIncludedResources(String ... includedResources) {
        try {
            this.includedResources = includedResources;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initExcludedResources(String ... excludedResources) {
        try {
            this.excludedResources = excludedResources;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void execute() {
        try {
            String archivePath = this.archive.getAbsolutePath();
            String noArchive = "couldn't find " + archivePath;
            Assert.assertTrue((String)noArchive, (boolean)this.archive.exists());
            ArrayList<String> resources = new ArrayList<String>();
            JarFile jarFile = new JarFile(this.archive);
            try {
                String resource;
                int n;
                int n2;
                String[] stringArray;
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    resources.add(entry.getName());
                }
                if (this.includedResources != null) {
                    stringArray = this.includedResources;
                    n2 = this.includedResources.length;
                    n = 0;
                    while (n < n2) {
                        resource = stringArray[n];
                        String noResource = String.format("couldn't find resource %s in %s", resource, archivePath);
                        Assert.assertTrue((String)noResource, (boolean)resources.contains(resource));
                        ++n;
                    }
                }
                if (this.excludedResources != null) {
                    stringArray = this.excludedResources;
                    n2 = this.excludedResources.length;
                    n = 0;
                    while (n < n2) {
                        resource = stringArray[n];
                        String message = String.format("mistakenly found resource %s in %s", resource, archivePath);
                        Assert.assertFalse((String)message, (boolean)resources.contains(resource));
                        ++n;
                    }
                }
                this.manifest = jarFile.getManifest();
            }
            finally {
                jarFile.close();
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Manifest getManifest() {
        try {
            return this.manifest;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

