/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.internal.acme;

import java.io.File;
import org.aspectj.lang.SoftException;
import protoj.lang.ProjectLayout;
import protoj.lang.ScriptSession;
import protoj.lang.StandardProject;
import protoj.lang.internal.ProtoProject;
import protoj.lang.internal.acme.AssertArchive;
import protoj.lang.internal.acme.AssertClean;
import protoj.lang.internal.acme.AssertCommandHelp;
import protoj.lang.internal.acme.AssertCompile;
import protoj.lang.internal.acme.AssertDebug;
import protoj.lang.internal.acme.AssertDirConf;
import protoj.lang.internal.acme.AssertFail;
import protoj.lang.internal.acme.AssertJunit;
import protoj.lang.internal.acme.AssertJvmarg;
import protoj.lang.internal.acme.AssertProjectHelp;
import protoj.lang.internal.acme.AssertPublish;
import protoj.lang.internal.acme.AssertScp;
import protoj.lang.internal.acme.AssertTar;
import protoj.lang.internal.acme.AssertVerifyTar;
import protoj.lang.internal.acme.AssertVersion;

public final class AcmeSession {
    private StandardProject project;

    public AcmeSession() {
        try {
            this.project = new ProtoProject().createSampleProject("acme");
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void execute() {
        try {
            String acmeFile = this.getAcmeFile().getAbsolutePath();
            ScriptSession session = this.project.createScriptSession();
            session.addCommand("help", new AssertProjectHelp(this), "warn");
            session.addCommand("", new AssertCompile(this), "empty");
            session.addCommand("\"compile -i acme/util\"", new AssertCompile(this), "util");
            session.addCommand("\"dirconf -name profile -interpolate\"", new AssertDirConf(this), "config");
            session.addCommand("compile", new AssertCompile(this), "all");
            session.addCommand("fail", new AssertFail(this), null);
            session.addCommand("retrieve", new AssertCompile(this), "retrieve");
            session.addCommand("junit", new AssertJunit(this), null);
            session.addCommand("test", new AssertJunit(this), null);
            session.addCommand("help", new AssertProjectHelp(this), "ok");
            session.addCommand("\"help compile\"", new AssertCommandHelp(this), null);
            session.addCommand("version", new AssertVersion(this), null);
            session.addCommand("scp", new AssertScp(this), "no archive option");
            session.addCommand("\"scp -arc wibble\"", new AssertScp(this), "no dir option");
            session.addCommand("\"scp -arc wibble -dir a@http://b:c -pass b\"", new AssertScp(this), "bad archive");
            session.addCommand("\"scp -arc foo -dir a@http://b:c -pass p\"", new AssertScp(this), "missing archive");
            session.addCommand("archive", new AssertArchive(this), null);
            session.addCommand("\"publish -artifact foo\"", new AssertPublish(this), "foo");
            session.addCommand("publish", new AssertPublish(this), "all");
            session.addCommand("verify-tar", new AssertVerifyTar(this), "no tar");
            session.addCommand("\"tar -nosrc\"", new AssertTar(this), null);
            session.addCommand("verify-tar", new AssertVerifyTar(this), "no src");
            session.addCommand("tar", new AssertTar(this), null);
            session.addCommand("verify-tar", new AssertVerifyTar(this), "ok");
            session.addCommand("\"scp -arc foo -dir a@http://b:c\"", new AssertScp(this), "ok");
            session.addCommand("\"scp -arc foo -dir a@http://b:c -pass p\"", new AssertScp(this), "ok");
            session.addCommand("\"scp -arc foo -dir a@http://b:c -key a\"", new AssertScp(this), "ok");
            session.addCommand("\"scp -arc foo -dir a@http://b:c -key a -phrase a\"", new AssertScp(this), "ok");
            session.addCommand(String.format("create-file \"opts -Dacme.file=%s\"", acmeFile), new AssertJvmarg(this), null);
            session.addCommand("help \"opts -Dprotoj.debug.help -Dprotoj.debug.port.help=12345\"", new AssertDebug(this), "help port 12345");
            session.addCommand("help \"opts -Dprotoj.debug.help\"", new AssertDebug(this), "help port default");
            session.addCommand("help \"opts -Dprotoj.debug.version\"", new AssertDebug(this), "help wrong command");
            session.addCommand("junit \"opts -Dprotoj.junit.debug -Dprotoj.junit.debug.port=12345\"", new AssertDebug(this), "junit port 12345");
            session.addCommand("junit \"opts -Dprotoj.junit.debug\"", new AssertDebug(this), "junit port default");
            session.addCommand("message \"opts -Dprotoj.junit.debug\"", new AssertDebug(this), "junit wrong command");
            session.addCommand("message \"opts -Dprotoj.main.debug -Dprotoj.main.debug.port=12345\"", new AssertDebug(this), "main port 12345");
            session.addCommand("message \"opts -Dprotoj.main.debug\"", new AssertDebug(this), "main port default");
            session.addCommand("\"dirconf -name profile -clean\"", new AssertDirConf(this), "undo");
            session.addCommand("clean", new AssertClean(this), null);
            session.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public StandardProject getProject() {
        try {
            return this.project;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getAcmeFile() {
        try {
            ProjectLayout acmeLayout = this.getProject().getLayout();
            return new File(acmeLayout.getTargetDir(), "testvmarg.txt");
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

