/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.internal.acme;

import java.io.File;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.aspectj.lang.SoftException;
import org.junit.Assert;
import protoj.lang.ProjectLayout;
import protoj.lang.ScriptSession;
import protoj.lang.internal.VerifyArchive;
import protoj.lang.internal.acme.AcmeSession;
import protoj.util.ArgRunnable;
import protoj.util.CommandTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AssertArchive
implements ArgRunnable<ScriptSession> {
    private final AcmeSession acmeSession;

    public AssertArchive(AcmeSession acmeSession) {
        try {
            this.acmeSession = acmeSession;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    @Override
    public void run(ScriptSession projectSession) {
        try {
            this.assertAcmeClassesJar();
            this.assertFooClassesJar();
            this.assertFooSourcesJar();
            this.assertFooJavadocJar();
            this.assertLogContents();
            this.assertAdvice(projectSession);
            CommandTask exec = projectSession.getCurrentExec();
            Assert.assertTrue((String)exec.getResult(), (boolean)exec.isSuccess());
            ProjectLayout acmeLayout = this.acmeSession.getProject().getLayout();
            acmeLayout.getLogFile().delete();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void assertAdvice(ScriptSession projectSession) {
        try {
            String stdout = projectSession.getCurrentExec().getStdout();
            String expected = "before advice triggered at StandardProject.assemble execution join point";
            Assert.assertTrue((String)stdout, (boolean)stdout.contains(expected));
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void assertLogContents() {
        try {
            String log = this.acmeSession.getProject().getLayout().loadLog();
            Assert.assertTrue((String)log, (boolean)log.contains("archive"));
            Assert.assertTrue((String)log, (boolean)log.contains("Task \"archive\" started"));
            Assert.assertTrue((String)log, (boolean)log.contains("Building jar:"));
            Assert.assertTrue((String)log, (boolean)log.contains("acme-1.0.jar"));
            Assert.assertTrue((String)log, (boolean)log.contains("foo.jar"));
            Assert.assertTrue((String)log, (boolean)log.contains("Task \"archive\" finished"));
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void assertFooClassesJar() {
        try {
            ProjectLayout acmeLayout = this.acmeSession.getProject().getLayout();
            File jar = new File(acmeLayout.getArchiveDir(), "foo.jar");
            VerifyArchive verify = new VerifyArchive(jar);
            verify.initIncludedResources("test.txt");
            verify.initExcludedResources("acme/AcmeProject.class", "acme/core/AcmeCore.class");
            verify.execute();
            Manifest manifest = verify.getManifest();
            Assert.assertTrue((boolean)manifest.getMainAttributes().values().contains("foo"));
            Assert.assertTrue((boolean)manifest.getMainAttributes().values().contains("bar"));
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void assertAcmeClassesJar() {
        try {
            ProjectLayout acmeLayout = this.acmeSession.getProject().getLayout();
            File libJar = new File(acmeLayout.getLibDir(), "acme-1.0.jar");
            Assert.assertTrue((boolean)libJar.exists());
            File jar = new File(acmeLayout.getArchiveDir(), "acme-1.0.jar");
            VerifyArchive verify = new VerifyArchive(jar);
            verify.initIncludedResources("acme/AcmeProject.class", "acme/core/AcmeCore.class", "test.txt", "org/junit/Test.class");
            verify.execute();
            Attributes mainAttributes = verify.getManifest().getMainAttributes();
            Assert.assertFalse((boolean)mainAttributes.values().contains("foo"));
            Assert.assertTrue((boolean)mainAttributes.containsKey(Attributes.Name.CLASS_PATH));
            String classpathValue = mainAttributes.getValue(Attributes.Name.CLASS_PATH);
            Assert.assertTrue((String)classpathValue, (boolean)classpathValue.contains("aspectjrt.jar"));
            Assert.assertFalse((String)"junit jar merged so shouldn't be in manifest classpath", (boolean)classpathValue.contains("junit-4.4.jar"));
            Assert.assertTrue((boolean)mainAttributes.containsKey(Attributes.Name.MAIN_CLASS));
            String mainClassValue = mainAttributes.getValue(Attributes.Name.MAIN_CLASS);
            Assert.assertEquals((Object)mainClassValue, (Object)"acme.AcmeProject");
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void assertFooSourcesJar() {
        try {
            ProjectLayout acmeLayout = this.acmeSession.getProject().getLayout();
            File jar = new File(acmeLayout.getArchiveDir(), "foosources-sources.jar");
            VerifyArchive verify = new VerifyArchive(jar);
            verify.initIncludedResources("acme/AcmeProject.java", "org/junit/Test.java");
            verify.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void assertFooJavadocJar() {
        try {
            ProjectLayout acmeLayout = this.acmeSession.getProject().getLayout();
            File jar = new File(acmeLayout.getArchiveDir(), "foojavadoc-javadoc.jar");
            VerifyArchive verify = new VerifyArchive(jar);
            verify.initIncludedResources("acme/AcmeProject.html");
            verify.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

