/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.internal.acme;

import java.io.File;
import org.aspectj.lang.SoftException;
import org.junit.Assert;
import protoj.lang.ProjectLayout;
import protoj.lang.ScriptSession;
import protoj.lang.internal.acme.AcmeSession;
import protoj.util.ArgRunnable;
import protoj.util.CommandTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AssertClean
implements ArgRunnable<ScriptSession> {
    private final AcmeSession acmeSession;

    public AssertClean(AcmeSession acmeSession) {
        try {
            this.acmeSession = acmeSession;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    @Override
    public void run(ScriptSession projectSession) {
        try {
            ProjectLayout acmeLayout = this.acmeSession.getProject().getLayout();
            String log = this.acmeSession.getProject().getLayout().loadLog();
            File targetDir = acmeLayout.getTargetDir();
            Assert.assertFalse((String)("shouldn't find " + targetDir.getAbsolutePath()), (boolean)targetDir.exists());
            File classesDir = acmeLayout.getClassesDir();
            Assert.assertFalse((String)("shouldn't find " + classesDir.getAbsolutePath()), (boolean)classesDir.exists());
            Assert.assertTrue((String)log, (boolean)log.contains("clean"));
            CommandTask exec = projectSession.getCurrentExec();
            Assert.assertTrue((String)exec.getResult(), (boolean)exec.isSuccess());
            acmeLayout.getLogFile().delete();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

