/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.internal.acme;

import java.io.File;
import org.aspectj.lang.SoftException;
import org.junit.Assert;
import protoj.lang.ProjectLayout;
import protoj.lang.ScriptSession;
import protoj.lang.internal.acme.AcmeSession;
import protoj.util.ArgRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AssertCompile
implements ArgRunnable<ScriptSession> {
    public static final String EMPTY = "empty";
    public static final String ALL = "all";
    public static final String UTIL = "util";
    public static final String RETRIEVE = "retrieve";
    private final AcmeSession acmeSession;

    public AssertCompile(AcmeSession acmeSession) {
        try {
            this.acmeSession = acmeSession;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    @Override
    public void run(ScriptSession projectSession) {
        try {
            ProjectLayout acmeLayout = this.acmeSession.getProject().getLayout();
            String log = this.acmeSession.getProject().getLayout().loadLog();
            String tag = projectSession.getCurrentTag();
            File acmeProjectClass = new File(acmeLayout.getClassesDir(), "acme/AcmeProject.class");
            File acmeUtilClass = new File(acmeLayout.getClassesDir(), "acme/util/AcmeUtil.class");
            File langSourcesJar = new File(acmeLayout.getLibDir(), "commons-lang-2.4-sources.jar");
            File httpClassesJar = new File(acmeLayout.getLibDir(), "httpclient-4.0-beta2.jar");
            File resource = new File(acmeLayout.getClassesDir(), "test.txt");
            if (tag.equals(EMPTY)) {
                Assert.assertFalse((String)("shouldn't find " + acmeUtilClass.getAbsolutePath()), (boolean)acmeUtilClass.exists());
                Assert.assertFalse((String)("shouldn't find " + acmeProjectClass.getAbsolutePath()), (boolean)acmeProjectClass.exists());
                Assert.assertFalse((String)("shouldn't find " + httpClassesJar.getAbsolutePath()), (boolean)httpClassesJar.exists());
                Assert.assertFalse((String)("shouldn't find " + langSourcesJar.getAbsolutePath()), (boolean)langSourcesJar.exists());
            } else if (tag.equals(RETRIEVE)) {
                Assert.assertTrue((String)("couldn't find " + httpClassesJar.getAbsolutePath()), (boolean)httpClassesJar.exists());
                Assert.assertFalse((String)("shouldn't find " + langSourcesJar.getAbsolutePath()), (boolean)langSourcesJar.exists());
            } else if (tag.equals(UTIL)) {
                Assert.assertTrue((String)("couldn't find " + acmeUtilClass.getAbsolutePath()), (boolean)acmeUtilClass.exists());
                Assert.assertFalse((String)("shouldn't find " + acmeProjectClass.getAbsolutePath()), (boolean)acmeProjectClass.exists());
                Assert.assertTrue((String)log, (boolean)log.contains("overriding compile memory: 16m"));
                Assert.assertTrue((String)log, (boolean)log.contains("overriding compile source: 1.5"));
            } else if (tag.equals(ALL)) {
                Assert.assertTrue((String)("couldn't find " + acmeUtilClass.getAbsolutePath()), (boolean)acmeUtilClass.exists());
                Assert.assertTrue((String)("couldn't find " + acmeProjectClass.getAbsolutePath()), (boolean)acmeProjectClass.exists());
                Assert.assertTrue((String)("couldn't find " + resource.getAbsolutePath()), (boolean)resource.exists());
                Assert.assertTrue((String)log, (boolean)log.contains("compile"));
                Assert.assertTrue((String)log, (boolean)log.contains("Task \"ajc\" started"));
                Assert.assertTrue((String)log, (boolean)log.contains("Task \"ajc\" finished"));
                Assert.assertTrue((String)log, (boolean)log.contains("overriding compile memory: 18m"));
                Assert.assertTrue((String)log, (boolean)log.contains("overriding compile source: 5"));
            }
            Assert.assertTrue((boolean)projectSession.getCurrentExec().isSuccess());
            acmeLayout.getLogFile().delete();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

