/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.internal.acme;

import org.aspectj.lang.SoftException;
import org.junit.Assert;
import protoj.lang.ProjectLayout;
import protoj.lang.ScriptSession;
import protoj.lang.internal.acme.AcmeSession;
import protoj.util.ArgRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AssertDebug
implements ArgRunnable<ScriptSession> {
    public static final String HELP_PORT_12345 = "help port 12345";
    public static final String HELP_PORT_DEFAULT = "help port default";
    public static final String HELP_WRONG_CMD = "help wrong command";
    public static final String JUNIT_PORT_12345 = "junit port 12345";
    public static final String JUNIT_PORT_DEFAULT = "junit port default";
    public static final String JUNIT_WRONG_CMD = "junit wrong command";
    public static final String MAIN_PORT_12345 = "main port 12345";
    public static final String MAIN_PORT_DEFAULT = "main port default";
    private final AcmeSession acmeSession;
    private int testIndex;

    public AssertDebug(AcmeSession acmeSession) {
        try {
            this.testIndex = 0;
            this.acmeSession = acmeSession;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    @Override
    public void run(ScriptSession projectSession) {
        try {
            ProjectLayout acmeLayout = this.acmeSession.getProject().getLayout();
            String tag = projectSession.getCurrentTag();
            String stdout = projectSession.getCurrentExec().getStdout();
            String log = this.acmeSession.getProject().getLayout().loadLog();
            if (tag.equals(HELP_PORT_12345)) {
                Assert.assertTrue((String)stdout, (boolean)stdout.contains("Listening for transport dt_socket at address: 12345"));
                Assert.assertTrue((String)log, (boolean)log.contains("debug mode configured at port 12345 for command: help"));
            } else if (tag.equals(HELP_PORT_DEFAULT)) {
                Assert.assertTrue((String)stdout, (boolean)stdout.contains("Listening for transport dt_socket at address: 11111"));
                Assert.assertTrue((String)log, (boolean)log.contains("debug mode configured at port 11111 for command: help"));
            } else if (tag.equals(HELP_WRONG_CMD)) {
                Assert.assertFalse((String)stdout, (boolean)stdout.contains("Listening for transport dt_socket at address: "));
            } else if (tag.equals(JUNIT_PORT_12345)) {
                Assert.assertTrue((String)stdout, (boolean)stdout.contains("Listening for transport dt_socket at address: 12345"));
                Assert.assertTrue((String)stdout, (boolean)stdout.contains("debug mode configured at port 12345 for the junit vm"));
            } else if (tag.equals(JUNIT_PORT_DEFAULT)) {
                Assert.assertTrue((String)stdout, (boolean)stdout.contains("Listening for transport dt_socket at address: 11111"));
                Assert.assertTrue((String)stdout, (boolean)stdout.contains("debug mode configured at port 11111 for the junit vm"));
            } else if (tag.equals(JUNIT_WRONG_CMD)) {
                Assert.assertFalse((String)stdout, (boolean)stdout.contains("Listening for transport dt_socket at address: "));
            } else if (tag.equals(MAIN_PORT_12345)) {
                Assert.assertTrue((String)stdout, (boolean)stdout.contains("Listening for transport dt_socket at address: 12345"));
                Assert.assertTrue((String)stdout, (boolean)stdout.contains("debug mode configured at port 12345 for the main vm"));
            } else if (tag.equals(MAIN_PORT_DEFAULT)) {
                Assert.assertTrue((String)stdout, (boolean)stdout.contains("Listening for transport dt_socket at address: 11111"));
                Assert.assertTrue((String)stdout, (boolean)stdout.contains("debug mode configured at port 11111 for the main vm"));
            }
            acmeLayout.getLogFile().delete();
            ++this.testIndex;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

