/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.internal.acme;

import java.io.File;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.aspectj.lang.SoftException;
import org.junit.Assert;
import protoj.lang.ProjectLayout;
import protoj.lang.ScriptSession;
import protoj.lang.internal.acme.AcmeSession;
import protoj.util.ArgRunnable;
import protoj.util.CommandTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AssertDirConf
implements ArgRunnable<ScriptSession> {
    public static final String CONFIG = "config";
    public static final String UNDO = "undo";
    private final AcmeSession acmeSession;

    public AssertDirConf(AcmeSession acmeSession) {
        try {
            this.acmeSession = acmeSession;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    @Override
    public void run(ScriptSession projectSession) {
        try {
            ProjectLayout layout = this.acmeSession.getProject().getLayout();
            File propertiesFile = layout.getPropertiesFile();
            File sampleTextFile = new File(layout.getDocsDir(), "sample.txt");
            File samplePropertiesFile = new File(layout.getDocsDir(), "sample.properties");
            String tag = projectSession.getCurrentTag();
            if (tag.equals(CONFIG)) {
                File appProps = new File(layout.getConfDir(), "app.properties");
                File projProps = new File(layout.getConfDir(), "acme.properties");
                Assert.assertFalse((boolean)appProps.exists());
                Assert.assertFalse((boolean)projProps.exists());
                Assert.assertTrue((String)("couldn't find " + propertiesFile.getAbsolutePath()), (boolean)propertiesFile.exists());
                Assert.assertTrue((String)("couldn't find " + samplePropertiesFile.getAbsolutePath()), (boolean)samplePropertiesFile.exists());
                PropertiesConfiguration config = new PropertiesConfiguration(propertiesFile);
                Assert.assertTrue((boolean)config.containsKey("color"));
                Assert.assertEquals((Object)config.getString("color"), (Object)"red");
                Assert.assertTrue((boolean)config.containsKey("greeting"));
                Assert.assertEquals((Object)config.getString("greeting"), (Object)"hi");
                Assert.assertTrue((boolean)config.containsKey("foo"));
                Assert.assertEquals((Object)config.getString("foo"), (Object)"hi");
                Assert.assertTrue((boolean)config.containsKey("drink"));
                Assert.assertEquals((Object)config.getString("drink"), (Object)"coffee");
                Assert.assertTrue((boolean)config.containsKey("random"));
                Assert.assertEquals((Object)config.getString("random"), (Object)"coffee");
                Assert.assertTrue((boolean)config.containsKey("word"));
                Assert.assertEquals((Object)config.getString("word"), (Object)"hi");
                Assert.assertTrue((boolean)config.containsKey("protoj.main.memory"));
                Assert.assertEquals((Object)config.getString("protoj.main.memory"), (Object)"17m");
                Assert.assertTrue((boolean)config.containsKey("protoj.junit.memory"));
                Assert.assertEquals((Object)config.getString("protoj.junit.memory"), (Object)"15m");
                Assert.assertTrue((boolean)config.containsKey("protoj.memory.publish"));
                Assert.assertEquals((Object)config.getString("protoj.memory.publish"), (Object)"33m");
                Assert.assertTrue((boolean)config.containsKey("protoj.compile.memory"));
                Assert.assertEquals((Object)config.getString("protoj.compile.memory"), (Object)"18m");
                Assert.assertTrue((boolean)config.containsKey("protoj.compile.source"));
                Assert.assertEquals((Object)config.getString("protoj.compile.source"), (Object)"5");
                Assert.assertTrue((String)("couldn't find " + samplePropertiesFile.getAbsolutePath()), (boolean)sampleTextFile.exists());
                String sampleText = FileUtils.readFileToString((File)sampleTextFile);
                Assert.assertTrue((String)sampleText, (boolean)sampleText.contains("My favorite color is red"));
                Assert.assertTrue((String)sampleText, (boolean)sampleText.contains("My favorite acme constant is AcmeUtil constant"));
                Assert.assertTrue((String)sampleText, (boolean)sampleText.contains("My favorite version of Java is " + System.getProperty("java.version")));
            } else if (tag.equals(UNDO)) {
                Assert.assertFalse((String)("shouldn't find " + propertiesFile.getAbsolutePath()), (boolean)propertiesFile.exists());
                Assert.assertFalse((String)("shouldn't find " + sampleTextFile.getAbsolutePath()), (boolean)sampleTextFile.exists());
            }
            CommandTask exec = projectSession.getCurrentExec();
            Assert.assertTrue((String)exec.getResult(), (boolean)exec.isSuccess());
            layout.getLogFile().delete();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

