/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.internal.acme;

import java.io.File;
import org.aspectj.lang.SoftException;
import org.junit.Assert;
import protoj.lang.ProjectLayout;
import protoj.lang.ScriptSession;
import protoj.lang.internal.acme.AcmeSession;
import protoj.util.ArgRunnable;
import protoj.util.CommandTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AssertJunit
implements ArgRunnable<ScriptSession> {
    private final AcmeSession session;

    public AssertJunit(AcmeSession acmeSession) {
        try {
            this.session = acmeSession;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    @Override
    public void run(ScriptSession projectSession) {
        try {
            ProjectLayout acmeLayout = this.session.getProject().getLayout();
            String log = this.session.getProject().getLayout().loadLog();
            File testReport = new File(acmeLayout.getJunitReportsDir(), "TEST-acme.SampleTest.txt");
            Assert.assertTrue((String)("couldn't find " + testReport.getAbsolutePath()), (boolean)testReport.exists());
            Assert.assertTrue((String)log, (boolean)log.contains("junit"));
            CommandTask exec = projectSession.getCurrentExec();
            Assert.assertTrue((String)exec.getResult(), (boolean)exec.isSuccess());
            acmeLayout.getLogFile().delete();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

