/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.internal.acme;

import org.aspectj.lang.SoftException;
import org.junit.Assert;
import protoj.lang.ProjectLayout;
import protoj.lang.ScriptSession;
import protoj.lang.internal.acme.AcmeSession;
import protoj.util.ArgRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AssertProjectHelp
implements ArgRunnable<ScriptSession> {
    public static final String WARN = "warn";
    public static final String OK = "ok";
    private final AcmeSession acmeSession;

    public AssertProjectHelp(AcmeSession acmeSession) {
        try {
            this.acmeSession = acmeSession;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    @Override
    public void run(ScriptSession projectSession) {
        try {
            ProjectLayout acmeLayout = this.acmeSession.getProject().getLayout();
            String log = this.acmeSession.getProject().getLayout().loadLog();
            String stdout = projectSession.getCurrentExec().getStdout();
            String tag = projectSession.getCurrentTag();
            if (tag.equals(WARN)) {
                Assert.assertTrue((boolean)stdout.contains("did you remember"));
            } else if (tag.equals(OK)) {
                Assert.assertFalse((String)log, (boolean)log.contains("Usage: acme"));
                Assert.assertTrue((String)stdout, (boolean)stdout.contains("Usage: acme"));
            }
            acmeLayout.getLogFile().delete();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

