/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.internal.acme;

import java.io.File;
import org.aspectj.lang.SoftException;
import org.junit.Assert;
import protoj.lang.ProjectLayout;
import protoj.lang.ScriptSession;
import protoj.lang.internal.acme.AcmeSession;
import protoj.util.ArgRunnable;
import protoj.util.CommandTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AssertPublish
implements ArgRunnable<ScriptSession> {
    private final AcmeSession acmeSession;
    public static final String ALL = "all";
    public static final String FOO = "foo";

    public AssertPublish(AcmeSession acmeSession) {
        try {
            this.acmeSession = acmeSession;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    @Override
    public void run(ScriptSession projectSession) {
        try {
            ProjectLayout acmeLayout = this.acmeSession.getProject().getLayout();
            File fooRepoDir = new File(acmeLayout.getTargetDir(), "repo/org/acme/foo/1.0");
            File fooPom = new File(fooRepoDir, "foo-1.0.pom");
            File fooClasses = new File(fooRepoDir, "foo-1.0.jar");
            File acmeRepoDir = new File(acmeLayout.getTargetDir(), "repo/org/acme/acme/1.0");
            File acmePom = new File(acmeRepoDir, "acme-1.0.pom");
            File acmeClasses = new File(acmeRepoDir, "acme-1.0.jar");
            File acmeSources = new File(acmeRepoDir, "acme-1.0-sources.jar");
            File acmeJavadoc = new File(acmeRepoDir, "acme-1.0-javadoc.jar");
            String tag = projectSession.getCurrentTag();
            if (tag.equals(FOO)) {
                this.assertExists(fooPom, true);
                this.assertExists(fooClasses, true);
                this.assertArtifacts(acmePom, false);
                this.assertArtifacts(acmeClasses, false);
                this.assertArtifacts(acmeSources, false);
                this.assertArtifacts(acmeJavadoc, false);
            } else {
                this.assertArtifacts(acmePom, true);
                this.assertArtifacts(acmeClasses, true);
                this.assertArtifacts(acmeSources, true);
                this.assertArtifacts(acmeJavadoc, true);
            }
            CommandTask exec = projectSession.getCurrentExec();
            Assert.assertTrue((String)exec.getResult(), (boolean)exec.isSuccess());
            acmeLayout.getLogFile().delete();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void assertArtifacts(File artifact, boolean exists) {
        try {
            File repoDir = artifact.getParentFile();
            String name = artifact.getName();
            File artifactChecksum = new File(repoDir, String.valueOf(name) + ".md5");
            File artifactDigest = new File(repoDir, String.valueOf(name) + ".sha1");
            File artifactSig = new File(repoDir, String.valueOf(name) + ".asc");
            File artifactSigChecksum = new File(repoDir, String.valueOf(name) + ".asc.md5");
            File artifactSigDigest = new File(repoDir, String.valueOf(name) + ".asc.sha1");
            this.assertExists(artifact, exists);
            this.assertExists(artifactChecksum, exists);
            this.assertExists(artifactDigest, exists);
            this.assertExists(artifactSig, exists);
            this.assertExists(artifactSigChecksum, exists);
            this.assertExists(artifactSigDigest, exists);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void assertExists(File file, boolean exists) {
        try {
            if (exists) {
                String message = "couldn't find " + file.getAbsolutePath();
                Assert.assertTrue((String)message, (boolean)file.exists());
            } else {
                String message = "shouldn't have found " + file.getAbsolutePath();
                Assert.assertFalse((String)message, (boolean)file.exists());
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

