/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.internal.acme;

import org.aspectj.lang.SoftException;
import org.junit.Assert;
import protoj.lang.ProjectLayout;
import protoj.lang.ScriptSession;
import protoj.lang.internal.acme.AcmeSession;
import protoj.util.ArgRunnable;
import protoj.util.CommandTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AssertScp
implements ArgRunnable<ScriptSession> {
    public static final String MANDATORY_ARCHIVE_OPTION = "no archive option";
    public static final String MANDATORY_DIR_OPTION = "no dir option";
    public static final String BAD_ARCHIVE = "bad archive";
    public static final String MISSING_ARCHIVE = "missing archive";
    public static final String OK = "ok";
    private final AcmeSession acmeSession;

    public AssertScp(AcmeSession acmeSession) {
        try {
            this.acmeSession = acmeSession;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    @Override
    public void run(ScriptSession projectSession) {
        try {
            ProjectLayout acmeLayout = this.acmeSession.getProject().getLayout();
            CommandTask exec = projectSession.getCurrentExec();
            String log = this.acmeSession.getProject().getLayout().loadLog();
            String tag = projectSession.getCurrentTag();
            if (tag.equals(MANDATORY_ARCHIVE_OPTION)) {
                Assert.assertTrue((boolean)log.contains("please specify the name of an archive"));
                Assert.assertFalse((String)exec.getResult(), (boolean)exec.isSuccess());
            } else if (tag.equals(MANDATORY_DIR_OPTION)) {
                Assert.assertTrue((boolean)log.contains("please specify a dir option"));
                Assert.assertFalse((String)exec.getResult(), (boolean)exec.isSuccess());
            } else if (tag.equals(BAD_ARCHIVE)) {
                Assert.assertTrue((boolean)log.contains("unrecognized archive name"));
                Assert.assertFalse((String)exec.getResult(), (boolean)exec.isSuccess());
            } else if (tag.equals(MISSING_ARCHIVE)) {
                Assert.assertTrue((boolean)log.contains("can't find the archive at"));
                Assert.assertFalse((String)exec.getResult(), (boolean)exec.isSuccess());
            } else if (tag.equals(OK)) {
                Assert.assertTrue((boolean)log.contains("skipping the remote copy"));
                Assert.assertTrue((String)exec.getResult(), (boolean)exec.isSuccess());
            }
            acmeLayout.getLogFile().delete();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

