/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.internal.acme;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.GUnzip;
import org.apache.tools.ant.taskdefs.Untar;
import org.aspectj.lang.SoftException;
import org.junit.Assert;
import protoj.lang.ProjectLayout;
import protoj.lang.ScriptSession;
import protoj.lang.internal.acme.AcmeSession;
import protoj.util.AntTarget;
import protoj.util.ArgRunnable;
import protoj.util.CommandTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AssertTar
implements ArgRunnable<ScriptSession> {
    private final AcmeSession acmeSession;

    public AssertTar(AcmeSession acmeSession) {
        try {
            this.acmeSession = acmeSession;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    @Override
    public void run(ScriptSession projectSession) {
        try {
            ProjectLayout acmeLayout = this.acmeSession.getProject().getLayout();
            String log = this.acmeSession.getProject().getLayout().loadLog();
            File acmeTargetDir = acmeLayout.getTargetDir();
            File extractDir = new File(acmeTargetDir, "assert-tar");
            File acmeDir = new File(extractDir, "acme-1.0");
            File logDir = new File(acmeDir, "log");
            File binDir = new File(acmeDir, "bin");
            File confDir = new File(acmeDir, "conf");
            File propertiesFile = new File(confDir, "all.project.properties");
            File docsDir = new File(acmeDir, "docs");
            File protoLogFile = new File(logDir, "protoj.log");
            File acmeLogFile = new File(logDir, "acme.log");
            File libDir = new File(acmeDir, "lib");
            File javadocJar = new File(libDir, "junit-4.4-javadoc.jar");
            File sourcesJar = new File(libDir, "junit-4.4-sources.jar");
            File aspectJar = new File(libDir, "aspectjrt.jar");
            File targetDir = new File(acmeDir, "target");
            File classesDir = new File(acmeDir, "classes");
            File srcDir = new File(acmeDir, "src");
            File privateDir = new File(acmeDir, "private");
            File redFile = new File(privateDir, "red.txt");
            File partPrivateDir = new File(acmeDir, "part-private");
            File amberFile = new File(partPrivateDir, "amber.txt");
            File greenFile = new File(partPrivateDir, "green.txt");
            Assert.assertTrue((String)log, (boolean)log.contains("tar"));
            CommandTask exec = projectSession.getCurrentExec();
            Assert.assertTrue((String)exec.getResult(), (boolean)exec.isSuccess());
            this.extractTarFiles(projectSession, extractDir);
            Assert.assertTrue((boolean)acmeDir.exists());
            Assert.assertTrue((boolean)binDir.exists());
            Assert.assertTrue((boolean)confDir.exists());
            Assert.assertFalse((boolean)propertiesFile.exists());
            Assert.assertTrue((boolean)docsDir.exists());
            Assert.assertTrue((boolean)libDir.exists());
            Assert.assertFalse((boolean)javadocJar.exists());
            Assert.assertFalse((boolean)sourcesJar.exists());
            Assert.assertTrue((boolean)logDir.exists());
            Assert.assertTrue((boolean)acmeLogFile.exists());
            Assert.assertFalse((boolean)protoLogFile.exists());
            Assert.assertTrue((boolean)aspectJar.exists());
            Assert.assertFalse((boolean)targetDir.exists());
            Assert.assertFalse((boolean)classesDir.exists());
            if (this.isNosrcSpecified(projectSession)) {
                Assert.assertFalse((boolean)srcDir.exists());
            } else {
                Assert.assertTrue((boolean)srcDir.exists());
            }
            Assert.assertFalse((boolean)privateDir.exists());
            Assert.assertFalse((boolean)redFile.exists());
            Assert.assertTrue((boolean)partPrivateDir.exists());
            Assert.assertFalse((boolean)greenFile.exists());
            Assert.assertTrue((boolean)amberFile.exists());
            FileUtils.deleteDirectory((File)extractDir);
            acmeLayout.getLogFile().delete();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void extractTarFiles(ScriptSession projectSession, File extractDir) {
        try {
            ProjectLayout acmeLayout = this.acmeSession.getProject().getLayout();
            extractDir.mkdirs();
            File acmeArchiveDir = acmeLayout.getArchiveDir();
            AntTarget target = new AntTarget("protoj-acme-gunzip");
            File gzFile = new File(acmeArchiveDir, "acme.tar.gz");
            File tarFile = new File(acmeArchiveDir, "acme.tar");
            target.initLogging(2);
            GUnzip gunzip = new GUnzip();
            gunzip.setTaskName("gunzip");
            target.addTask((Task)gunzip);
            gunzip.setSrc(gzFile);
            Untar untar = new Untar();
            untar.setTaskName("untar");
            untar.setSrc(tarFile);
            target.addTask((Task)untar);
            untar.setDest(extractDir);
            target.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private boolean isNosrcSpecified(ScriptSession projectSession) {
        try {
            String currentCommand = projectSession.getCurrentCommand();
            return currentCommand.contains("-nosrc");
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

