/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.internal.acme;

import org.aspectj.lang.SoftException;
import org.junit.Assert;
import protoj.lang.ProjectLayout;
import protoj.lang.ScriptSession;
import protoj.lang.internal.acme.AcmeSession;
import protoj.util.ArgRunnable;
import protoj.util.CommandTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AssertVerifyTar
implements ArgRunnable<ScriptSession> {
    public static final String NO_TAR = "no tar";
    public static final String NO_SRC = "no src";
    public static final String OK = "ok";
    private final AcmeSession acmeSession;
    private int testIndex;

    public AssertVerifyTar(AcmeSession acmeSession) {
        try {
            this.testIndex = 0;
            this.acmeSession = acmeSession;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    @Override
    public void run(ScriptSession projectSession) {
        try {
            ProjectLayout acmeLayout = this.acmeSession.getProject().getLayout();
            String log = this.acmeSession.getProject().getLayout().loadLog();
            String tag = projectSession.getCurrentTag();
            if (tag.equals(NO_TAR)) {
                Assert.assertTrue((String)log, (boolean)log.contains("unable to find tar file"));
            } else if (tag.equals(NO_SRC)) {
                Assert.assertTrue((String)log, (boolean)log.contains("unable to find src directory"));
            } else if (tag.equals(OK)) {
                CommandTask exec = projectSession.getCurrentExec();
                Assert.assertTrue((String)exec.getStdout(), (boolean)exec.isSuccess());
            }
            acmeLayout.getLogFile().delete();
            ++this.testIndex;
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

