/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.internal.sample;

import java.io.File;
import org.aspectj.lang.SoftException;
import org.junit.Assert;
import protoj.lang.ProjectLayout;
import protoj.lang.ScriptSession;
import protoj.lang.StandardProject;
import protoj.lang.internal.ProtoProject;
import protoj.util.ArgRunnable;
import protoj.util.CommandTask;

public final class AjcSession {
    private static final String CONFIG = "config";
    private static final String EMPTY = "empty";
    private static final String CLEAN = "clean";
    private static final String COMPILE = "compile";
    private static final String RETRIEVE = "retrieve";
    private static final String HELLO_AJC = "hello-ajc";
    private static final String HELP = "help";
    private StandardProject project;

    public AjcSession() {
        try {
            this.project = new ProtoProject().createSampleProject("ajc");
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void execute() {
        try {
            ScriptSession session = this.project.createScriptSession();
            ArgRunnableImplementation listener = new ArgRunnableImplementation();
            session.addCommand("", listener, EMPTY);
            session.addCommand("\"dirconf -name profile\"", listener, CONFIG);
            session.addCommand(RETRIEVE, listener, RETRIEVE);
            session.addCommand(COMPILE, listener, COMPILE);
            session.addCommand(HELP, listener, HELP);
            session.addCommand(HELLO_AJC, listener, HELLO_AJC);
            session.addCommand(CLEAN, listener, CLEAN);
            session.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ StandardProject access$0(AjcSession arg0) {
        try {
            return arg0.project;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ArgRunnableImplementation
    implements ArgRunnable<ScriptSession> {
        private ArgRunnableImplementation() {
            try {
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }

        @Override
        public void run(ScriptSession session) {
            try {
                ProjectLayout layout = AjcSession.access$0(AjcSession.this).getLayout();
                CommandTask exec = session.getCurrentExec();
                String stdout = exec.getStdout();
                AjcSession.access$0(AjcSession.this).getLogger().debug((Object)stdout);
                String log = AjcSession.access$0(AjcSession.this).getLayout().loadLog();
                File ajcProjectClass = new File(layout.getClassesDir(), "org/ajc/system/AjcProject.class");
                File ajcCoreClass = new File(layout.getClassesDir(), "org/ajc/core/AjcCore.class");
                File ivyFile = new File(layout.getClassesDir(), "ajc/ivy.xml");
                File aopFile = new File(layout.getClassesDir(), "META-INF/aop.xml");
                String tag = session.getCurrentTag();
                if (tag.equals(AjcSession.RETRIEVE)) {
                    File libDir = layout.getLibDir();
                    File sources = new File(libDir, "junit-4.5-sources.jar");
                    File classes = new File(libDir, "junit-4.5.jar");
                    Assert.assertTrue((boolean)sources.exists());
                    Assert.assertTrue((boolean)classes.exists());
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                } else if (tag.equals(AjcSession.CONFIG)) {
                    File appProps = new File(layout.getConfDir(), "app.properties");
                    File projProps = new File(layout.getConfDir(), "ajc.properties");
                    Assert.assertTrue((boolean)appProps.exists());
                    Assert.assertTrue((boolean)projProps.exists());
                } else if (tag.equals(AjcSession.EMPTY)) {
                    Assert.assertTrue((boolean)ajcCoreClass.exists());
                    Assert.assertTrue((boolean)ivyFile.exists());
                    Assert.assertFalse((boolean)ajcProjectClass.exists());
                    Assert.assertFalse((boolean)aopFile.exists());
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                } else if (tag.equals(AjcSession.COMPILE)) {
                    Assert.assertTrue((boolean)ajcProjectClass.exists());
                    Assert.assertTrue((boolean)ajcCoreClass.exists());
                    Assert.assertTrue((boolean)ivyFile.exists());
                    Assert.assertTrue((boolean)aopFile.exists());
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                } else if (tag.equals(AjcSession.HELP)) {
                    Assert.assertTrue((String)stdout, (boolean)stdout.contains(AjcSession.HELLO_AJC));
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                } else if (tag.equals(AjcSession.HELLO_AJC)) {
                    Assert.assertTrue((String)stdout, (boolean)stdout.contains("hello from this sample project!"));
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                } else if (tag.equals(AjcSession.CLEAN)) {
                    Assert.assertTrue((String)stdout, (boolean)stdout.contains("load time weaving appears to work"));
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                }
                layout.getLogFile().delete();
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }
    }
}

