/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.internal.sample;

import java.io.File;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.aspectj.lang.SoftException;
import org.junit.Assert;
import protoj.lang.ProjectLayout;
import protoj.lang.ScriptSession;
import protoj.lang.StandardProject;
import protoj.lang.internal.ProtoProject;
import protoj.lang.internal.VerifyArchive;
import protoj.util.ArgRunnable;
import protoj.util.CommandTask;

public final class AlienSession {
    private static final String RETRIEVE = "retrieve";
    private static final String EMPTY = "empty";
    private static final String UNDO = "undo";
    private static final String COMPILE = "compile";
    private static final String CONFIG = "config";
    private static final String CLEAN = "clean";
    private static final String TEST = "test";
    private static final String FIND_ALIEN = "find alien";
    private static final String ARCHIVE = "archive";
    private static final String NO_JAR = "no jar";
    private static final String VERSION = "version";
    private static final String COMMAND_HELP = "command-help";
    private static final String PROJECT_HELP = "project-help";
    private StandardProject project;

    public AlienSession() {
        try {
            this.project = new ProtoProject().createSampleProject("alien");
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void execute() {
        try {
            ScriptSession session = this.project.createScriptSession();
            ArgRunnableImplementation listener = new ArgRunnableImplementation();
            session.addCommand("", listener, EMPTY);
            session.addCommand("\"dirconf -name profile\"", listener, CONFIG);
            session.addCommand(COMPILE, listener, COMPILE);
            session.addCommand("help", listener, PROJECT_HELP);
            session.addCommand("\"help test\"", listener, COMMAND_HELP);
            session.addCommand(VERSION, listener, VERSION);
            session.addCommand(RETRIEVE, listener, RETRIEVE);
            session.addCommand(ARCHIVE, listener, ARCHIVE);
            session.addCommand("\"find-alien -gx milky-way\"", listener, FIND_ALIEN);
            session.addCommand(TEST, listener, TEST);
            session.addCommand("\"dirconf -name profile -clean\"", listener, UNDO);
            session.addCommand(CLEAN, listener, CLEAN);
            session.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void verifyContents(File jar, String ... names) {
        try {
            VerifyArchive verifyArchive = new VerifyArchive(jar);
            verifyArchive.initIncludedResources(names);
            verifyArchive.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ StandardProject access$0(AlienSession arg0) {
        try {
            return arg0.project;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ void access$1(AlienSession arg0, File arg1, String[] arg2) {
        try {
            arg0.verifyContents(arg1, arg2);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ArgRunnableImplementation
    implements ArgRunnable<ScriptSession> {
        private ArgRunnableImplementation() {
            try {
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }

        @Override
        public void run(ScriptSession session) {
            try {
                ProjectLayout layout = AlienSession.access$0(AlienSession.this).getLayout();
                CommandTask exec = session.getCurrentExec();
                String stdout = exec.getStdout();
                AlienSession.access$0(AlienSession.this).getLogger().debug((Object)stdout);
                String log = AlienSession.access$0(AlienSession.this).getLayout().loadLog();
                File alienProjectClass = new File(layout.getClassesDir(), "alien/AlienProject.class");
                File testReport = new File(layout.getJunitReportsDir(), "TEST-alien.test.AlienTest.txt");
                String tag = session.getCurrentTag();
                if (tag.equals(AlienSession.CLEAN)) {
                    Assert.assertFalse((boolean)layout.getTargetDir().exists());
                    Assert.assertFalse((boolean)layout.getClassesDir().exists());
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                } else if (tag.equals(AlienSession.EMPTY)) {
                    Assert.assertFalse((boolean)alienProjectClass.exists());
                } else if (tag.equals(AlienSession.UNDO)) {
                    File topSecretFile = new File(layout.getDocsDir(), "topsecret.txt");
                    Assert.assertTrue((!topSecretFile.exists() ? 1 : 0) != 0);
                    File alien = new File(layout.getConfDir(), "alien.test.properties");
                    Assert.assertTrue((!alien.exists() ? 1 : 0) != 0);
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                } else if (tag.equals(AlienSession.TEST)) {
                    Assert.assertTrue((boolean)testReport.exists());
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                } else if (tag.equals(AlienSession.RETRIEVE)) {
                    File libDir = layout.getLibDir();
                    File sourcesJar = new File(libDir, "junit-4.5-sources.jar");
                    File classesJar = new File(libDir, "junit-4.5.jar");
                    Assert.assertTrue((boolean)sourcesJar.exists());
                    Assert.assertTrue((boolean)classesJar.exists());
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                } else if (tag.equals(AlienSession.FIND_ALIEN)) {
                    Assert.assertTrue((String)stdout, (boolean)stdout.contains("No life found in the milky-way"));
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                } else if (tag.equals(AlienSession.ARCHIVE)) {
                    File classesJar = new File(layout.getArchiveDir(), "alien.jar");
                    AlienSession.access$1(AlienSession.this, classesJar, new String[]{"alien/core/AlienCore.class", "alien/AlienProject.class"});
                    File javadocJar = new File(layout.getArchiveDir(), "alien-javadoc.jar");
                    AlienSession.access$1(AlienSession.this, javadocJar, new String[]{"index.html", "alien/core/AlienCore.html", "alien/AlienProject.html"});
                    File sourcesJar = new File(layout.getArchiveDir(), "alien-sources.jar");
                    AlienSession.access$1(AlienSession.this, sourcesJar, new String[]{"alien/core/AlienCore.java", "alien/AlienProject.java"});
                    Assert.assertTrue((boolean)classesJar.exists());
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                } else if (tag.equals(AlienSession.NO_JAR)) {
                    Assert.assertTrue((String)log, (boolean)log.contains("no jar file"));
                    Assert.assertFalse((String)log, (boolean)exec.isSuccess());
                } else if (tag.equals(AlienSession.CONFIG)) {
                    File appProps = new File(layout.getConfDir(), "app.properties");
                    File projProps = new File(layout.getConfDir(), "alien.properties");
                    Assert.assertTrue((boolean)appProps.exists());
                    Assert.assertTrue((boolean)projProps.exists());
                    File topSecretFile = new File(layout.getDocsDir(), "topsecret.txt");
                    Assert.assertTrue((boolean)topSecretFile.exists());
                    File alien = new File(layout.getConfDir(), "alien.test.properties");
                    Assert.assertTrue((boolean)alien.exists());
                    PropertiesConfiguration config = new PropertiesConfiguration(alien);
                    Assert.assertTrue((boolean)config.containsKey("galaxy"));
                    Assert.assertEquals((Object)config.getString("galaxy"), (Object)"milky-way");
                    Assert.assertTrue((boolean)config.containsKey("planet"));
                    Assert.assertEquals((Object)config.getString("planet"), (Object)"venus");
                    Assert.assertTrue((boolean)config.containsKey("side"));
                    Assert.assertEquals((Object)config.getString("side"), (Object)"dark");
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                } else if (tag.equals(AlienSession.COMPILE)) {
                    Assert.assertTrue((boolean)alienProjectClass.exists());
                } else if (tag.equals(AlienSession.VERSION)) {
                    Assert.assertTrue((String)stdout, (boolean)stdout.contains("1.0"));
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                } else if (tag.equals(AlienSession.COMMAND_HELP)) {
                    Assert.assertTrue((String)stdout, (boolean)stdout.contains("Executes the junit tests"));
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                } else if (tag.equals(AlienSession.PROJECT_HELP)) {
                    Assert.assertTrue((String)stdout, (boolean)stdout.contains("find-alien"));
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                }
                layout.getLogFile().delete();
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }
    }
}

