/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.internal.sample;

import java.io.File;
import org.aspectj.lang.SoftException;
import org.junit.Assert;
import protoj.lang.ProjectLayout;
import protoj.lang.ScriptSession;
import protoj.lang.StandardProject;
import protoj.lang.internal.ProtoProject;
import protoj.util.ArgRunnable;
import protoj.util.CommandTask;

public final class BasicSession {
    private static final String CONFIG = "config";
    private static final String COMPILE = "compile";
    private static final String RETRIEVE = "retrieve";
    private static final String HELLO_BASIC = "hello-basic";
    private static final String HELP = "help";
    private StandardProject project;

    public BasicSession() {
        try {
            this.project = new ProtoProject().createSampleProject("basic");
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void execute() {
        try {
            ScriptSession session = this.project.createScriptSession();
            ArgRunnableImplementation listener = new ArgRunnableImplementation();
            session.addCommand("\"dirconf -name profile\"", listener, CONFIG);
            session.addCommand(COMPILE, listener, COMPILE);
            session.addCommand(RETRIEVE, listener, RETRIEVE);
            session.addCommand(HELP, listener, HELP);
            session.addCommand(HELLO_BASIC, listener, HELLO_BASIC);
            session.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ StandardProject access$0(BasicSession arg0) {
        try {
            return arg0.project;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ArgRunnableImplementation
    implements ArgRunnable<ScriptSession> {
        private ArgRunnableImplementation() {
            try {
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }

        @Override
        public void run(ScriptSession session) {
            try {
                ProjectLayout layout = BasicSession.access$0(BasicSession.this).getLayout();
                CommandTask exec = session.getCurrentExec();
                String stdout = exec.getStdout();
                BasicSession.access$0(BasicSession.this).getLogger().debug((Object)stdout);
                String log = BasicSession.access$0(BasicSession.this).getLayout().loadLog();
                String tag = session.getCurrentTag();
                if (tag.equals(BasicSession.RETRIEVE)) {
                    File libDir = layout.getLibDir();
                    File sources = new File(libDir, "junit-4.5-sources.jar");
                    File classes = new File(libDir, "junit-4.5.jar");
                    Assert.assertTrue((boolean)sources.exists());
                    Assert.assertTrue((boolean)classes.exists());
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                } else if (tag.equals(BasicSession.COMPILE)) {
                    File basicProjectClass = new File(layout.getClassesDir(), "org/basic/system/BasicProject.class");
                    Assert.assertTrue((boolean)basicProjectClass.exists());
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                } else if (tag.equals(BasicSession.CONFIG)) {
                    File appProps = new File(layout.getConfDir(), "app.properties");
                    File projProps = new File(layout.getConfDir(), "basic.properties");
                    Assert.assertTrue((boolean)appProps.exists());
                    Assert.assertTrue((boolean)projProps.exists());
                } else if (tag.equals(BasicSession.HELP)) {
                    Assert.assertTrue((String)stdout, (boolean)stdout.contains(BasicSession.HELLO_BASIC));
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                } else if (tag.equals(BasicSession.HELLO_BASIC)) {
                    Assert.assertTrue((String)stdout, (boolean)stdout.contains("hello from this sample project!"));
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                }
                layout.getLogFile().delete();
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }
    }
}

