/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.internal.sample;

import java.io.File;
import org.aspectj.lang.SoftException;
import org.junit.Assert;
import protoj.lang.ProjectLayout;
import protoj.lang.ScriptSession;
import protoj.lang.StandardProject;
import protoj.lang.internal.ProtoProject;
import protoj.lang.internal.VerifyArchive;
import protoj.util.ArgRunnable;
import protoj.util.CommandTask;

public final class HelloWorldSession {
    private static final String CONFIG = "config";
    private static final String CLEAN = "clean";
    private static final String HELLO_WORLD = "hello world";
    private static final String VERIFY_TAR = "verify-tar";
    private static final String TAR = "tar";
    private static final String TEST = "test";
    private static final String ARCHIVE = "archive";
    private static final String VERSION = "version";
    private static final String COMMAND_HELP = "command-help";
    private static final String PROJECT_HELP = "project-help";
    private StandardProject project;

    public HelloWorldSession() {
        try {
            this.project = new ProtoProject().createSampleProject("helloworld");
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void execute() {
        try {
            ScriptSession session = this.project.createScriptSession();
            ArgRunnableImplementation listener = new ArgRunnableImplementation();
            session.addCommand("\"dirconf -name profile\"", listener, CONFIG);
            session.addCommand("help", listener, PROJECT_HELP);
            session.addCommand("\"help test\"", listener, COMMAND_HELP);
            session.addCommand(VERSION, listener, VERSION);
            session.addCommand(ARCHIVE, listener, ARCHIVE);
            session.addCommand(TEST, listener, TEST);
            session.addCommand(TAR, listener, TAR);
            session.addCommand(VERIFY_TAR, listener, VERIFY_TAR);
            session.addCommand("hello-world", listener, HELLO_WORLD);
            session.addCommand(CLEAN, listener, CLEAN);
            session.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ StandardProject access$0(HelloWorldSession arg0) {
        try {
            return arg0.project;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ArgRunnableImplementation
    implements ArgRunnable<ScriptSession> {
        private ArgRunnableImplementation() {
            try {
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }

        @Override
        public void run(ScriptSession session) {
            try {
                ProjectLayout layout = HelloWorldSession.access$0(HelloWorldSession.this).getLayout();
                CommandTask exec = session.getCurrentExec();
                String stdout = exec.getStdout();
                HelloWorldSession.access$0(HelloWorldSession.this).getLogger().debug((Object)stdout);
                String log = HelloWorldSession.access$0(HelloWorldSession.this).getLayout().loadLog();
                String tag = session.getCurrentTag();
                if (tag.equals(HelloWorldSession.CLEAN)) {
                    Assert.assertFalse((boolean)layout.getTargetDir().exists());
                    Assert.assertFalse((boolean)layout.getClassesDir().exists());
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                } else if (tag.equals(HelloWorldSession.HELLO_WORLD)) {
                    Assert.assertTrue((String)stdout, (boolean)stdout.contains("Hello World!"));
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                } else if (tag.equals(HelloWorldSession.CONFIG)) {
                    File appProps = new File(layout.getConfDir(), "app.properties");
                    File projProps = new File(layout.getConfDir(), "helloworld.properties");
                    Assert.assertTrue((boolean)appProps.exists());
                    Assert.assertTrue((boolean)projProps.exists());
                } else if (tag.equals(HelloWorldSession.VERIFY_TAR)) {
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                } else if (tag.equals(HelloWorldSession.TAR)) {
                    File tarFile = new File(layout.getArchiveDir(), "hello-world.tar.gz");
                    Assert.assertTrue((boolean)tarFile.exists());
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                } else if (tag.equals(HelloWorldSession.TEST)) {
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                } else if (tag.equals(HelloWorldSession.ARCHIVE)) {
                    File classesJar = new File(layout.getArchiveDir(), "hello-world-9.9.jar");
                    this.verifyContents(classesJar, "helloworld/HelloWorld.class");
                    File javadocJar = new File(layout.getArchiveDir(), "hello-world-9.9-javadoc.jar");
                    this.verifyContents(javadocJar, "index.html", "helloworld/HelloWorld.html");
                    File sourcesJar = new File(layout.getArchiveDir(), "hello-world-9.9-sources.jar");
                    this.verifyContents(sourcesJar, "helloworld/HelloWorld.java");
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                } else if (tag.equals(HelloWorldSession.VERSION)) {
                    Assert.assertTrue((String)stdout, (boolean)stdout.contains("9.9"));
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                } else if (tag.equals(HelloWorldSession.COMMAND_HELP)) {
                    Assert.assertTrue((String)stdout, (boolean)stdout.contains("Executes the junit tests"));
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                } else if (tag.equals(HelloWorldSession.PROJECT_HELP)) {
                    Assert.assertTrue((String)stdout, (boolean)stdout.contains("Available commands"));
                    Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                }
                layout.getLogFile().delete();
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }

        private void verifyContents(File jar, String ... names) {
            try {
                VerifyArchive verifyArchive = new VerifyArchive(jar);
                verifyArchive.initIncludedResources(names);
                verifyArchive.execute();
                return;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw exception;
                }
                throw new SoftException((Throwable)exception);
            }
        }
    }
}

