/*
 * Decompiled with CFR 0.152.
 */
package protoj.lang.internal.sample;

import java.io.File;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.aspectj.lang.SoftException;
import org.junit.Assert;
import protoj.lang.ProjectLayout;
import protoj.lang.ScriptSession;
import protoj.lang.StandardProject;
import protoj.lang.internal.ProtoProject;
import protoj.util.AntTarget;
import protoj.util.ArgRunnable;
import protoj.util.CommandTask;

public final class ServerDemoSession {
    private static final String ARCHIVE = "archive";
    private static final String STOP = "stop";
    private static final String START = "start";
    private static final String DIST = "dist";
    private static final String COMPILE = "compile";
    private static final String RETRIEVE = "retrieve";
    private static final String CONFIG = "config";
    private static final String EXPAND = "expand";
    private StandardProject serverDemoProject;
    private ProtoProject protoProject;
    private StandardProject distProject;

    public ServerDemoSession() {
        try {
            this.protoProject = new ProtoProject();
            this.serverDemoProject = this.protoProject.createServerDemoProjectDelegate();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void execute() {
        try {
            this.executeSampleProject();
            this.distProject = this.createDistProject();
            this.executeDistProject();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void executeDistProject() {
        try {
            final ScriptSession session = this.distProject.createScriptSession();
            ArgRunnable<ScriptSession> listener = new ArgRunnable<ScriptSession>(){
                {
                    try {
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }

                @Override
                public void run(ScriptSession arg) {
                    try {
                        CommandTask exec = session.getCurrentExec();
                        String log = ServerDemoSession.access$0(ServerDemoSession.this).getLayout().loadLog();
                        Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }
            };
            session.addCommand("\"dirconf -name profile -interpolate\"", listener, CONFIG);
            session.addCommand(START, listener, START);
            session.addCommand(STOP, listener, STOP);
            if (Os.isFamily((String)"windows")) {
                System.out.println("check the start and stop command manually");
            } else {
                session.execute();
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private void executeSampleProject() {
        try {
            final ScriptSession session = this.serverDemoProject.createScriptSession();
            ArgRunnable<ScriptSession> listener = new ArgRunnable<ScriptSession>(){
                {
                    try {
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }

                @Override
                public void run(ScriptSession arg) {
                    try {
                        CommandTask exec = session.getCurrentExec();
                        String log = ServerDemoSession.access$1(ServerDemoSession.this).getLayout().loadLog();
                        Assert.assertTrue((String)log, (boolean)exec.isSuccess());
                        return;
                    }
                    catch (Exception exception) {
                        if (exception instanceof RuntimeException) {
                            throw exception;
                        }
                        throw new SoftException((Throwable)exception);
                    }
                }
            };
            session.addCommand("\"dirconf -name profile -interpolate\"", listener, CONFIG);
            session.addCommand(RETRIEVE, listener, RETRIEVE);
            session.addCommand(COMPILE, listener, COMPILE);
            session.addCommand(EXPAND, listener, EXPAND);
            session.addCommand("\"dirconf -name profile -interpolate\"", listener, CONFIG);
            session.addCommand(ARCHIVE, listener, ARCHIVE);
            session.addCommand(DIST, listener, DIST);
            session.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private StandardProject createDistProject() {
        try {
            AntTarget target = new AntTarget("serverdemo");
            ProjectLayout sampleLayout = this.serverDemoProject.getLayout();
            target.initLogging(2);
            Java java = new Java();
            target.addTask((Task)java);
            java.setTaskName("serverdemo-java");
            java.setJar(new File(sampleLayout.getArchiveDir(), "serverdemo-dist.jar"));
            java.setFork(true);
            java.setFailonerror(true);
            java.setDir(sampleLayout.getTargetDir());
            target.execute();
            File rootDir = new File(sampleLayout.getTargetDir(), "serverdemo");
            StandardProject distProject = new StandardProject(rootDir, "serverdemo", null);
            distProject.getLayout().relaxPermissions();
            return distProject;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ StandardProject access$0(ServerDemoSession arg0) {
        try {
            return arg0.distProject;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    static /* synthetic */ StandardProject access$1(ServerDemoSession arg0) {
        try {
            return arg0.serverDemoProject;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

