/*
 * Decompiled with CFR 0.152.
 */
package protoj.util;

import java.io.File;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Manifest;
import org.aspectj.lang.SoftException;
import protoj.util.AntTarget;

public final class AssembleTask {
    private AntTarget target;
    private Jar jar;
    private Manifest manifest;

    public AssembleTask(File destFile, File basedir, File manifest, String includes, String excludes) {
        try {
            this.target = new AntTarget("protoj-archive");
            this.jar = new Jar();
            this.target.addTask((Task)this.jar);
            this.jar.setTaskName("archive");
            this.jar.setDestFile(destFile);
            this.jar.setBasedir(basedir);
            if (manifest != null) {
                this.jar.setManifest(manifest);
            }
            if (includes != null) {
                this.jar.setIncludes(includes);
            }
            if (excludes != null) {
                this.jar.setIncludes(excludes);
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initLogging() {
        try {
            this.target.initLogging(2);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Manifest.Attribute initManifest(String name, String value) {
        try {
            this.manifest = this.createManifest();
            Manifest.Attribute attribute = new Manifest.Attribute(name, value);
            this.manifest.addConfiguredAttribute(attribute);
            return attribute;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Jar getJar() {
        try {
            return this.jar;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void execute() {
        try {
            this.target.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private Manifest createManifest() {
        try {
            if (this.manifest == null) {
                this.manifest = new Manifest();
                this.jar.addConfiguredManifest(this.manifest);
            }
            return this.manifest;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

