/*
 * Decompiled with CFR 0.152.
 */
package protoj.util;

import java.io.File;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Commandline;
import org.aspectj.lang.SoftException;
import protoj.util.AntTarget;

public final class CommandTask {
    private String resultProperty;
    private String stdoutProperty;
    private String stderrProperty;
    private AntTarget target;
    private ExecTask execTask;

    public CommandTask(File dir, String executable, String argLine, String startArgs) {
        try {
            this.resultProperty = "protoj.result";
            this.stdoutProperty = "protoj.stdout";
            this.stderrProperty = "protoj.stderr";
            this.target = new AntTarget("protoj-execTask");
            this.execTask = new ExecTask();
            this.target.addTask((Task)this.execTask);
            this.execTask.setDir(dir);
            Commandline.Argument arg = this.execTask.createArg();
            if (this.isWindows()) {
                String winExecutable = this.getExecutable(executable, "bat");
                String startCommand = startArgs == null ? "" : (startArgs.length() == 0 ? "start" : "start " + startArgs);
                String line = String.format("/c %s %s %s", startCommand, winExecutable, argLine);
                arg.setLine(line);
                this.execTask.setExecutable("cmd.exe");
            } else {
                String nixExecutable = this.getExecutable(executable, "sh");
                arg.setLine(argLine);
                this.execTask.setExecutable(nixExecutable);
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initLogging(int level) {
        try {
            this.target.initLogging(level);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    private String getExecutable(String executable, String extension) {
        try {
            String winExe = executable.endsWith(".") ? String.valueOf(executable) + extension : executable;
            return winExe;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initSpawn(boolean spawn) {
        try {
            this.execTask.setSpawn(spawn);
            if (!spawn) {
                this.execTask.setOutputproperty(this.stdoutProperty);
                this.execTask.setErrorProperty(this.stderrProperty);
                this.execTask.setResultProperty(this.resultProperty);
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public boolean isWindows() {
        try {
            String osName = System.getProperty("os.name").toUpperCase();
            return osName.indexOf("WINDOWS") >= 0;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public ExecTask getExecTask() {
        try {
            return this.execTask;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void execute() {
        try {
            this.target.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getStdout() {
        try {
            return this.target.getProject().getProperty(this.stdoutProperty);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getStderr() {
        try {
            return this.target.getProject().getProperty(this.stderrProperty);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getResult() {
        try {
            return this.target.getProject().getProperty(this.resultProperty);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void writeOutput() {
        try {
            String systemErr;
            String systemOut = this.getStdout();
            if (systemOut != null && systemOut.length() > 0) {
                System.out.println(systemOut);
            }
            if ((systemErr = this.getStderr()) != null && systemErr.length() > 0) {
                System.err.println(systemErr);
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public boolean isSuccess() {
        try {
            return this.getResult().equals("0");
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

