/*
 * Decompiled with CFR 0.152.
 */
package protoj.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.aspectj.lang.SoftException;
import protoj.util.AntTarget;
import protoj.util.ArgRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaTask {
    private String resultProperty;
    private String stdoutProperty;
    private String stderrProperty;
    private AntTarget target;
    private Java javaTask;
    private String mainClass;
    private boolean fork;
    private String maxMemory;
    private boolean spawn;
    private List<String> args;
    private List<String> jvmargs;
    private String debugSuspend;
    private int debugPort;

    public JavaTask() {
        try {
            this.resultProperty = "protoj.result";
            this.stdoutProperty = "protoj.stdout";
            this.stderrProperty = "protoj.stderr";
            this.fork = false;
            this.maxMemory = "0";
            this.spawn = false;
            this.args = new ArrayList<String>();
            this.jvmargs = new ArrayList<String>();
            this.target = new AntTarget("protoj-start-vm");
            this.javaTask = new Java();
            this.javaTask.setTaskName("javaTask");
            this.target.addTask((Task)this.javaTask);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void setMainClass(String mainClass) {
        try {
            this.mainClass = mainClass;
            this.javaTask.setClassname(mainClass);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initLogging(int level) {
        try {
            this.target.initLogging(level);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initFork(String maxMemory, boolean spawn) {
        try {
            this.fork = true;
            this.maxMemory = maxMemory;
            this.spawn = spawn;
            this.javaTask.setFork(true);
            this.javaTask.setMaxmemory(maxMemory);
            this.javaTask.setSpawn(spawn);
            if (!spawn) {
                this.javaTask.setOutputproperty(this.stdoutProperty);
                this.javaTask.setErrorProperty(this.stderrProperty);
                this.javaTask.setResultProperty(this.resultProperty);
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initArgs(String ... args) {
        try {
            this.initArgs(Arrays.asList(args));
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initArgs(List<String> args) {
        try {
            this.args.addAll(args);
            for (String value : args) {
                Commandline.Argument arg = this.javaTask.createArg();
                arg.setValue(value);
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initJvmargs(String ... jvmargs) {
        try {
            this.initJvmargs(Arrays.asList(jvmargs));
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initJvmargs(List<String> jvmargs) {
        try {
            this.jvmargs.addAll(jvmargs);
            for (String value : jvmargs) {
                Commandline.Argument jvmarg = this.javaTask.createJvmarg();
                jvmarg.setValue(value);
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initClasspath(ArgRunnable<Path> config) {
        try {
            Path classpath = this.getJavaTask().createClasspath();
            config.run(classpath);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initDebug(int port, boolean suspend) {
        try {
            this.debugSuspend = suspend ? "y" : "n";
            this.debugPort = port;
            Commandline.Argument jvmarg = this.javaTask.createJvmarg();
            jvmarg.setLine("-Xdebug -Xrunjdwp:transport=dt_socket,address=" + port + ",server=y,suspend=" + this.debugSuspend);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initWeaving(File weaverJar) {
        try {
            Commandline.Argument jvmarg = this.javaTask.createJvmarg();
            jvmarg.setValue("-javaagent:" + weaverJar.getAbsolutePath());
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initLocalJmx() {
        try {
            Commandline.Argument jvmarg = this.javaTask.createJvmarg();
            jvmarg.setValue("-Dcom.sun.management.jmxremote");
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initRemoteJmx(Integer port) {
        try {
            Commandline.Argument jvmarg = this.javaTask.createJvmarg();
            jvmarg.setValue("-Dcom.sun.management.jmxremote.port=" + port);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getMainClass() {
        try {
            return this.mainClass;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getStdout() {
        try {
            return this.target.getProject().getProperty(this.stdoutProperty);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getStderr() {
        try {
            return this.target.getProject().getProperty(this.stderrProperty);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getResult() {
        try {
            return this.target.getProject().getProperty(this.resultProperty);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Java getJavaTask() {
        try {
            return this.javaTask;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getDebugSuspend() {
        try {
            return this.debugSuspend;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public int getDebugPort() {
        try {
            return this.debugPort;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public List<String> getArgs() {
        try {
            return this.args;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public List<String> getJvmargs() {
        try {
            return this.jvmargs;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void execute() {
        try {
            this.target.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void writeOutput() {
        try {
            String systemErr;
            String systemOut = this.getStdout();
            if (systemOut != null && systemOut.length() > 0) {
                System.out.println(systemOut);
            }
            if ((systemErr = this.getStderr()) != null && systemErr.length() > 0) {
                System.err.println(systemErr);
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public boolean isSuccess() {
        try {
            return this.getResult().equals("0");
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String toString() {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("mainclass=");
            builder.append(this.mainClass);
            builder.append(" args={");
            for (String arg : this.args) {
                builder.append(arg);
                builder.append(", ");
            }
            builder.append("} jvmargs={");
            for (String jvmarg : this.jvmargs) {
                builder.append(jvmarg);
                builder.append(", ");
            }
            builder.append("} fork=");
            builder.append(this.fork);
            builder.append(" spawn=");
            builder.append(this.spawn);
            builder.append(" maxMemory=");
            builder.append(this.maxMemory);
            return builder.toString();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

