/*
 * Decompiled with CFR 0.152.
 */
package protoj.util;

import java.io.File;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Javadoc;
import org.apache.tools.ant.types.DirSet;
import org.aspectj.lang.SoftException;
import protoj.util.AntTarget;

public final class JavadocTask {
    public static final String ERROR = "error";
    private AntTarget target;
    private Javadoc javadoc;
    private DirSet packageSet;

    public JavadocTask(File srcDir, File destDir) {
        try {
            this.target = new AntTarget("protoj-javadocs");
            destDir.mkdirs();
            this.javadoc = new Javadoc();
            this.target.addTask((Task)this.javadoc);
            this.javadoc.setTaskName("javadoc");
            this.javadoc.setDestdir(destDir);
            this.packageSet = new DirSet();
            this.packageSet.setDir(srcDir);
            this.javadoc.addPackageset(this.packageSet);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initDefault(String memory) {
        try {
            this.packageSet.setDefaultexcludes(true);
            this.javadoc.setMaxmemory(memory);
            this.packageSet.setIncludes("**");
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void execute() {
        try {
            this.target.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public DirSet getPackageSet() {
        try {
            return this.packageSet;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Javadoc getjavadoc() {
        try {
            return this.javadoc;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initLogging() {
        try {
            this.target.initLogging(2);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

