/*
 * Decompiled with CFR 0.152.
 */
package protoj.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.junit.BatchTest;
import org.apache.tools.ant.taskdefs.optional.junit.FormatterElement;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.aspectj.lang.SoftException;
import protoj.util.AntTarget;
import protoj.util.ArgRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JunitTask {
    public static final String ERROR = "error";
    private AntTarget target;
    private JUnitTask junit;
    private List<String> jvmargs;
    private String debugSuspend;
    private int debugPort;

    public JunitTask(File junitReportsDir, File javaDir, ArgRunnable<Path> classpathConfig, String maxMemory, String includes, String excludes) {
        try {
            this.jvmargs = new ArrayList<String>();
            this.target = new AntTarget("protoj-junit");
            junitReportsDir.mkdirs();
            try {
                this.junit = new JUnitTask();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.target.addTask((Task)this.junit);
            this.junit.setTaskName("junit-test");
            this.junit.setMaxmemory(maxMemory);
            this.junit.setHaltonerror(true);
            FormatterElement fe = new FormatterElement();
            FormatterElement.TypeAttribute type = new FormatterElement.TypeAttribute();
            type.setValue("plain");
            fe.setType(type);
            fe.setUseFile(true);
            this.junit.addFormatter(fe);
            Path classpath = this.junit.createClasspath();
            classpathConfig.run(classpath);
            BatchTest batchTest = this.junit.createBatchTest();
            batchTest.setFork(true);
            batchTest.setTodir(junitReportsDir);
            FileSet testFilter = new FileSet();
            testFilter.setDir(javaDir);
            if (includes != null) {
                testFilter.setIncludes(includes);
            }
            if (excludes != null) {
                testFilter.setExcludes(excludes);
            }
            batchTest.addFileSet(testFilter);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initDebug(int port, boolean suspend) {
        try {
            this.debugSuspend = suspend ? "y" : "n";
            this.debugPort = port;
            Commandline.Argument jvmarg = this.junit.createJvmarg();
            jvmarg.setLine("-Xdebug -Xrunjdwp:transport=dt_socket,address=" + this.debugPort + ",server=y,suspend=" + this.debugSuspend);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initJvmargs(String ... jvmargs) {
        try {
            this.initJvmargs(Arrays.asList(jvmargs));
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initJvmargs(List<String> jvmargs) {
        try {
            this.jvmargs.addAll(jvmargs);
            for (String value : jvmargs) {
                Commandline.Argument jvmarg = this.junit.createJvmarg();
                jvmarg.setValue(value);
            }
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void captureError() {
        try {
            this.junit.setErrorProperty(ERROR);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getError() {
        try {
            return this.target.getProject().getProperty(ERROR);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initLogging() {
        try {
            this.target.initLogging(2);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void execute() {
        try {
            this.target.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public JUnitTask getJunit() {
        try {
            return this.junit;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

