/*
 * Decompiled with CFR 0.152.
 */
package protoj.util;

import java.io.File;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.ssh.Scp;
import org.aspectj.lang.SoftException;
import protoj.util.AntTarget;

public final class ScpTask {
    private AntTarget target;
    private Scp task;

    public ScpTask() {
        try {
            this.target = new AntTarget("protoj-task");
            this.task = new Scp();
            this.task.setTaskName("task");
            this.target.addTask((Task)this.task);
            this.task.setTrust(true);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initCopyLocalToRemote(File localFile, String remoteToDir) {
        try {
            this.task.setRemoteTodir(remoteToDir);
            this.task.setLocalFile(localFile.getAbsolutePath());
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initLogging() {
        try {
            this.target.initLogging(2);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initKeyAuthentication(String passphrase, String keyFile) {
        try {
            this.task.setPassphrase(passphrase);
            this.task.setKeyfile(keyFile);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initPasswordAuthentication(String password) {
        try {
            this.task.setPassword(password);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Scp getTask() {
        try {
            return this.task;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void execute() {
        try {
            this.target.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

