/*
 * Decompiled with CFR 0.152.
 */
package protoj.util;

import java.io.File;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Tar;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.TarFileSet;
import org.aspectj.lang.SoftException;
import protoj.util.AntTarget;

public final class TarTask {
    private AntTarget target;
    private Tar tar;
    private File destFile;
    private String tarName;

    public TarTask(String destDir, String tarName) {
        try {
            this.target = new AntTarget("protoj-tar");
            new File(destDir).mkdirs();
            this.tarName = tarName;
            this.tar = new Tar();
            this.tar.setTaskName("tar");
            this.target.addTask((Task)this.tar);
            this.destFile = new File(destDir, String.valueOf(tarName) + ".tar.gz");
            this.tar.setDestFile(this.destFile);
            Tar.TarLongFileMode mode = new Tar.TarLongFileMode();
            mode.setValue("gnu");
            this.tar.setLongfile(mode);
            Tar.TarCompressionMethod method = new Tar.TarCompressionMethod();
            method.setValue("gzip");
            this.tar.setCompression(method);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void addFileSet(File dir, String prefix, String fileMode, String dirMode, String userName, String group, String includes, String excludes) {
        try {
            TarFileSet fileSet = new TarFileSet();
            fileSet.setProject(this.tar.getProject());
            fileSet.setDir(dir);
            if (prefix != null) {
                fileSet.setPrefix(prefix);
            }
            if (fileMode != null) {
                fileSet.setFileMode(fileMode);
            }
            if (dirMode != null) {
                fileSet.setDirMode(dirMode);
            }
            if (userName != null) {
                fileSet.setUserName(userName);
            }
            if (group != null) {
                fileSet.setGroup(group);
            }
            if (includes != null) {
                fileSet.setIncludes(includes);
            }
            if (excludes != null) {
                fileSet.setExcludes(excludes);
            }
            this.tar.add((ResourceCollection)fileSet);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void initLogging() {
        try {
            this.target.initLogging(2);
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public void execute() {
        try {
            this.target.execute();
            return;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getTarName() {
        try {
            return this.tarName;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public String getTarFilePath() {
        try {
            return this.destFile.getName();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public File getDestFile() {
        try {
            return this.destFile;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }

    public Tar getTar() {
        try {
            return this.tar;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw exception;
            }
            throw new SoftException((Throwable)exception);
        }
    }
}

