/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.base.ModuleKind;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.EnumSet;
import java.util.Optional;

public enum ComponentKind {
    COMPONENT(TypeNames.COMPONENT),
    SUBCOMPONENT(TypeNames.SUBCOMPONENT),
    PRODUCTION_COMPONENT(TypeNames.PRODUCTION_COMPONENT),
    PRODUCTION_SUBCOMPONENT(TypeNames.PRODUCTION_SUBCOMPONENT),
    MODULE(TypeNames.MODULE),
    PRODUCER_MODULE(TypeNames.PRODUCER_MODULE);

    private static final ImmutableSet<ComponentKind> PRODUCER_KINDS;
    private final ClassName annotation;

    public static ImmutableSet<ClassName> annotationsFor(Iterable<ComponentKind> kinds) {
        return (ImmutableSet)DaggerStreams.stream(kinds).map(ComponentKind::annotation).collect(DaggerStreams.toImmutableSet());
    }

    public static ImmutableSet<ComponentKind> getComponentKinds(XTypeElement element) {
        return (ImmutableSet)DaggerStreams.valuesOf(ComponentKind.class).filter(kind -> element.hasAnnotation(kind.annotation())).collect(DaggerStreams.toImmutableSet());
    }

    public static Optional<ComponentKind> forAnnotatedElement(XTypeElement element) {
        ImmutableSet<ComponentKind> kinds = ComponentKind.getComponentKinds(element);
        if (kinds.size() > 1) {
            throw new IllegalArgumentException(element + " cannot be annotated with more than one of " + ComponentKind.annotationsFor(kinds));
        }
        return kinds.stream().findAny();
    }

    private ComponentKind(ClassName annotation) {
        this.annotation = annotation;
    }

    public ClassName annotation() {
        return this.annotation;
    }

    public ImmutableSet<ModuleKind> legalModuleKinds() {
        return this.isProducer() ? Sets.immutableEnumSet(EnumSet.allOf(ModuleKind.class)) : Sets.immutableEnumSet((Enum)ModuleKind.MODULE, (Enum[])new ModuleKind[0]);
    }

    public ImmutableSet<ComponentKind> legalSubcomponentKinds() {
        return this.isProducer() ? Sets.immutableEnumSet((Enum)PRODUCTION_SUBCOMPONENT, (Enum[])new ComponentKind[0]) : Sets.immutableEnumSet((Enum)SUBCOMPONENT, (Enum[])new ComponentKind[]{PRODUCTION_SUBCOMPONENT});
    }

    public boolean isProducer() {
        return PRODUCER_KINDS.contains((Object)this);
    }

    static {
        PRODUCER_KINDS = ImmutableSet.of((Object)((Object)PRODUCTION_COMPONENT), (Object)((Object)PRODUCTION_SUBCOMPONENT), (Object)((Object)PRODUCER_MODULE));
    }
}

