package dagger.internal.codegen.binding;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.concurrent.LazyInit;
import dagger.internal.codegen.model.ComponentPath;
import java.lang.Override;
import java.lang.SuppressWarnings;

final class AutoValue_BindingGraph extends $AutoValue_BindingGraph {
  @LazyInit
  @SuppressWarnings("Immutable")
  private transient volatile ImmutableSet<ComponentRequirement> componentRequirements;

  @LazyInit
  @SuppressWarnings("Immutable")
  private transient volatile ImmutableMap<ComponentPath, ComponentDescriptor> componentDescriptorsByPath;

  @LazyInit
  @SuppressWarnings("Immutable")
  private transient volatile ImmutableList<BindingGraph> subgraphs;

  AutoValue_BindingGraph(dagger.internal.codegen.model.BindingGraph.ComponentNode componentNode$,
      BindingGraph.TopLevelBindingGraph topLevelBindingGraph$) {
    super(componentNode$, topLevelBindingGraph$);
  }

  @Override
  public ImmutableSet<ComponentRequirement> componentRequirements() {
    if (componentRequirements == null) {
      synchronized (this) {
        if (componentRequirements == null) {
          componentRequirements = super.componentRequirements();
          if (componentRequirements == null) {
            throw new NullPointerException("componentRequirements() cannot return null");
          }
        }
      }
    }
    return componentRequirements;
  }

  @Override
  public ImmutableMap<ComponentPath, ComponentDescriptor> componentDescriptorsByPath() {
    if (componentDescriptorsByPath == null) {
      synchronized (this) {
        if (componentDescriptorsByPath == null) {
          componentDescriptorsByPath = super.componentDescriptorsByPath();
          if (componentDescriptorsByPath == null) {
            throw new NullPointerException("componentDescriptorsByPath() cannot return null");
          }
        }
      }
    }
    return componentDescriptorsByPath;
  }

  @Override
  public ImmutableList<BindingGraph> subgraphs() {
    if (subgraphs == null) {
      synchronized (this) {
        if (subgraphs == null) {
          subgraphs = super.subgraphs();
          if (subgraphs == null) {
            throw new NullPointerException("subgraphs() cannot return null");
          }
        }
      }
    }
    return subgraphs;
  }
}
