package dagger.internal.codegen.binding;

import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XTypeElement;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.concurrent.LazyInit;
import dagger.internal.codegen.base.ComponentAnnotation;
import dagger.internal.codegen.model.Scope;
import java.lang.Object;
import java.lang.Override;
import java.lang.SuppressWarnings;
import java.util.Optional;

final class AutoValue_ComponentDescriptor extends $AutoValue_ComponentDescriptor {
  @LazyInit
  @SuppressWarnings("Immutable")
  private transient volatile ImmutableSet<ComponentRequirement> requirements;

  @LazyInit
  @SuppressWarnings("Immutable")
  private transient volatile ImmutableMap<XMethodElement, ComponentRequirement> dependenciesByDependencyMethod;

  @LazyInit
  @SuppressWarnings("Immutable")
  private transient volatile ImmutableMap<XTypeElement, ComponentDescriptor> childComponentsByElement;

  @LazyInit
  @SuppressWarnings("Immutable")
  private transient volatile ImmutableMap<BindingRequest, ComponentDescriptor.ComponentMethodDescriptor> firstMatchingComponentMethods;

  @LazyInit
  @SuppressWarnings("Immutable")
  private transient volatile int hashCode;

  @LazyInit
  @SuppressWarnings("Immutable")
  private transient volatile boolean hashCode$Memoized;

  AutoValue_ComponentDescriptor(ComponentAnnotation annotation$, XTypeElement typeElement$,
      ImmutableSet<ComponentRequirement> dependencies$, ImmutableSet<ModuleDescriptor> modules$,
      ImmutableSet<Scope> scopes$,
      ImmutableSet<ComponentDescriptor> childComponentsDeclaredByModules$,
      ImmutableBiMap<ComponentDescriptor.ComponentMethodDescriptor, ComponentDescriptor> childComponentsDeclaredByFactoryMethods$,
      ImmutableMap<ComponentDescriptor.ComponentMethodDescriptor, ComponentDescriptor> childComponentsDeclaredByBuilderEntryPoints$,
      ImmutableSet<ComponentDescriptor.ComponentMethodDescriptor> componentMethods$,
      Optional<ComponentCreatorDescriptor> creatorDescriptor$) {
    super(annotation$, typeElement$, dependencies$, modules$, scopes$, childComponentsDeclaredByModules$, childComponentsDeclaredByFactoryMethods$, childComponentsDeclaredByBuilderEntryPoints$, componentMethods$, creatorDescriptor$);
  }

  @Override
  ImmutableSet<ComponentRequirement> requirements() {
    if (requirements == null) {
      synchronized (this) {
        if (requirements == null) {
          requirements = super.requirements();
          if (requirements == null) {
            throw new NullPointerException("requirements() cannot return null");
          }
        }
      }
    }
    return requirements;
  }

  @Override
  public ImmutableMap<XMethodElement, ComponentRequirement> dependenciesByDependencyMethod() {
    if (dependenciesByDependencyMethod == null) {
      synchronized (this) {
        if (dependenciesByDependencyMethod == null) {
          dependenciesByDependencyMethod = super.dependenciesByDependencyMethod();
          if (dependenciesByDependencyMethod == null) {
            throw new NullPointerException("dependenciesByDependencyMethod() cannot return null");
          }
        }
      }
    }
    return dependenciesByDependencyMethod;
  }

  @Override
  public ImmutableMap<XTypeElement, ComponentDescriptor> childComponentsByElement() {
    if (childComponentsByElement == null) {
      synchronized (this) {
        if (childComponentsByElement == null) {
          childComponentsByElement = super.childComponentsByElement();
          if (childComponentsByElement == null) {
            throw new NullPointerException("childComponentsByElement() cannot return null");
          }
        }
      }
    }
    return childComponentsByElement;
  }

  @Override
  ImmutableMap<BindingRequest, ComponentDescriptor.ComponentMethodDescriptor> firstMatchingComponentMethods() {
    if (firstMatchingComponentMethods == null) {
      synchronized (this) {
        if (firstMatchingComponentMethods == null) {
          firstMatchingComponentMethods = super.firstMatchingComponentMethods();
          if (firstMatchingComponentMethods == null) {
            throw new NullPointerException("firstMatchingComponentMethods() cannot return null");
          }
        }
      }
    }
    return firstMatchingComponentMethods;
  }

  @Override
  public int hashCode() {
    if (!hashCode$Memoized) {
      synchronized (this) {
        if (!hashCode$Memoized) {
          hashCode = super.hashCode();
          hashCode$Memoized = true;
        }
      }
    }
    return hashCode;
  }

  @Override
  public boolean equals(Object that) {
    if (this == that) {
      return true;
    }
    return that instanceof AutoValue_ComponentDescriptor && this.hashCode() == that.hashCode() && super.equals(that);
  }
}
