/*
 * Decompiled with CFR 0.152.
 */
package dagger.spi.shaded.androidx.room.compiler.processing;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotationValue;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XVariableElement;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001e\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0012H\u0000\u001a\f\u0010\u0013\u001a\u00020\u0012*\u00020\u0014H\u0000\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\u0017\u001a\f\u0010\u0018\u001a\u00020\u0012*\u00020\u0012H\u0000\u001a\f\u0010\u0019\u001a\u00020\u0012*\u00020\u0012H\u0000\u001a\u0014\u0010\u001a\u001a\u00020\b*\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"NONE_TYPE_NAME", "Lcom/squareup/javapoet/ClassName;", "kotlin.jvm.PlatformType", "characterLiteralWithoutSingleQuotes", "", "c", "", "addMemberForCommonValue", "", "Lcom/squareup/javapoet/AnnotationSpec$Builder;", "memberName", "value", "", "addOriginatingElement", "Lcom/squareup/javapoet/TypeSpec$Builder;", "element", "Ldagger/spi/shaded/androidx/room/compiler/processing/XElement;", "rawTypeName", "Lcom/squareup/javapoet/TypeName;", "safeTypeName", "Ljavax/lang/model/type/TypeMirror;", "toAnnotationSpec", "Lcom/squareup/javapoet/AnnotationSpec;", "Ldagger/spi/shaded/androidx/room/compiler/processing/XAnnotation;", "tryBox", "tryUnbox", "visitAnnotationValue", "annotationValue", "Ldagger/spi/shaded/androidx/room/compiler/processing/XAnnotationValue;", "room-compiler-processing"})
public final class JavaPoetExtKt {
    private static final ClassName NONE_TYPE_NAME = ClassName.get((String)"dagger.spi.shaded.androidx.room.compiler.processing.error", (String)"NotAType", (String[])new String[0]);

    @NotNull
    public static final AnnotationSpec toAnnotationSpec(@NotNull XAnnotation $this$toAnnotationSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$toAnnotationSpec, (String)"<this>");
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)$this$toAnnotationSpec.getClassName());
        Iterable $this$forEach$iv = $this$toAnnotationSpec.getAnnotationValues();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XAnnotationValue it = (XAnnotationValue)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
            JavaPoetExtKt.visitAnnotationValue(builder, it);
        }
        AnnotationSpec annotationSpec = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)annotationSpec, (String)"builder.build()");
        return annotationSpec;
    }

    private static final void visitAnnotationValue(AnnotationSpec.Builder $this$visitAnnotationValue, XAnnotationValue annotationValue) {
        String name2 = annotationValue.getName();
        Object value2 = annotationValue.getValue();
        if (value2 instanceof XAnnotation) {
            Object[] objectArray = new Object[]{JavaPoetExtKt.toAnnotationSpec((XAnnotation)value2)};
            $this$visitAnnotationValue.addMember(name2, "$L", objectArray);
        } else if (value2 instanceof XVariableElement) {
            Object[] objectArray = new Object[]{((XVariableElement)value2).getType().getTypeName(), ((XVariableElement)value2).getName()};
            $this$visitAnnotationValue.addMember(name2, "$T.$L", objectArray);
        } else if (value2 instanceof XType) {
            Object[] objectArray = new Object[]{((XType)value2).getTypeName()};
            $this$visitAnnotationValue.addMember(name2, "$T.class", objectArray);
        } else if (value2 instanceof List) {
            Iterable $this$forEach$iv = (Iterable)value2;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                if (!(it instanceof XAnnotationValue)) continue;
                JavaPoetExtKt.visitAnnotationValue($this$visitAnnotationValue, (XAnnotationValue)it);
            }
        } else {
            JavaPoetExtKt.addMemberForCommonValue($this$visitAnnotationValue, name2, value2);
        }
    }

    private static final void addMemberForCommonValue(AnnotationSpec.Builder $this$addMemberForCommonValue, String memberName, Object value2) {
        if (value2 == null) {
            boolean bl = false;
            String string = "value == null, constant non-null value expected for " + memberName;
            throw new IllegalArgumentException(string.toString());
        }
        if (!SourceVersion.isName(memberName)) {
            boolean bl = false;
            String string = "not a valid name: " + memberName;
            throw new IllegalArgumentException(string.toString());
        }
        Object object = value2;
        if (object instanceof Class) {
            Object[] objectArray = new Object[]{value2};
            $this$addMemberForCommonValue.addMember(memberName, "$T.class", objectArray);
        } else if (object instanceof Enum) {
            Object[] objectArray = new Object[]{value2.getClass(), ((Enum)value2).name()};
            $this$addMemberForCommonValue.addMember(memberName, "$T.$L", objectArray);
        } else if (object instanceof String) {
            Object[] objectArray = new Object[]{value2};
            $this$addMemberForCommonValue.addMember(memberName, "$S", objectArray);
        } else if (object instanceof Float) {
            Object[] objectArray = new Object[]{value2};
            $this$addMemberForCommonValue.addMember(memberName, "$Lf", objectArray);
        } else if (object instanceof Character) {
            Object[] objectArray = new Object[]{JavaPoetExtKt.characterLiteralWithoutSingleQuotes(((Character)value2).charValue())};
            $this$addMemberForCommonValue.addMember(memberName, "'$L'", objectArray);
        } else {
            Object[] objectArray = new Object[]{value2};
            $this$addMemberForCommonValue.addMember(memberName, "$L", objectArray);
        }
    }

    private static final String characterLiteralWithoutSingleQuotes(char c) {
        String string;
        char c2 = c;
        if (c2 == '\b') {
            string = "\\b";
        } else if (c2 == '\t') {
            string = "\\t";
        } else if (c2 == '\n') {
            string = "\\n";
        } else if (c2 == '\f') {
            string = "\\u000c";
        } else if (c2 == '\r') {
            string = "\\r";
        } else if (c2 == '\"') {
            string = "\"";
        } else if (c2 == '\'') {
            string = "\\'";
        } else if (c2 == '\\') {
            string = "\\\\";
        } else if (Character.isISOControl(c)) {
            String string2 = "\\u%04x";
            Object[] objectArray = new Object[]{(int)c};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        } else {
            string = Character.toString(c);
        }
        return string;
    }

    @NotNull
    public static final TypeName safeTypeName(@NotNull TypeMirror $this$safeTypeName) {
        TypeName typeName2;
        Intrinsics.checkNotNullParameter((Object)$this$safeTypeName, (String)"<this>");
        if ($this$safeTypeName.getKind() == TypeKind.NONE) {
            ClassName className2 = NONE_TYPE_NAME;
            Intrinsics.checkNotNullExpressionValue((Object)className2, (String)"{\n    NONE_TYPE_NAME\n}");
            typeName2 = (TypeName)className2;
        } else {
            TypeName typeName3 = TypeName.get((TypeMirror)$this$safeTypeName);
            typeName2 = typeName3;
            Intrinsics.checkNotNullExpressionValue((Object)typeName3, (String)"{\n    TypeName.get(this)\n}");
        }
        return typeName2;
    }

    @NotNull
    public static final TypeSpec.Builder addOriginatingElement(@NotNull TypeSpec.Builder $this$addOriginatingElement, @NotNull XElement element) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$addOriginatingElement, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Element element2 = XElementKt.originatingElementForPoet(element);
            if (element2 == null) break block0;
            Element p0 = element2;
            boolean bl = false;
            $this$addOriginatingElement.addOriginatingElement(p0);
        }
        return $this$addOriginatingElement;
    }

    @NotNull
    public static final TypeName rawTypeName(@NotNull TypeName $this$rawTypeName) {
        TypeName typeName2;
        Intrinsics.checkNotNullParameter((Object)$this$rawTypeName, (String)"<this>");
        if ($this$rawTypeName instanceof ParameterizedTypeName) {
            ClassName className2 = ((ParameterizedTypeName)$this$rawTypeName).rawType;
            Intrinsics.checkNotNullExpressionValue((Object)className2, (String)"{\n        this.rawType\n    }");
            typeName2 = (TypeName)className2;
        } else {
            typeName2 = $this$rawTypeName;
        }
        return typeName2;
    }

    @NotNull
    public static final TypeName tryUnbox(@NotNull TypeName $this$tryUnbox) {
        TypeName typeName2;
        Intrinsics.checkNotNullParameter((Object)$this$tryUnbox, (String)"<this>");
        if ($this$tryUnbox.isBoxedPrimitive()) {
            TypeName typeName3 = $this$tryUnbox.unbox();
            typeName2 = typeName3;
            Intrinsics.checkNotNullExpressionValue((Object)typeName3, (String)"{\n        unbox()\n    }");
        } else {
            typeName2 = $this$tryUnbox;
        }
        return typeName2;
    }

    @NotNull
    public static final TypeName tryBox(@NotNull TypeName $this$tryBox) {
        TypeName typeName2;
        Intrinsics.checkNotNullParameter((Object)$this$tryBox, (String)"<this>");
        try {
            TypeName typeName3 = $this$tryBox.box();
            Intrinsics.checkNotNullExpressionValue((Object)typeName3, (String)"{\n        box()\n    }");
            typeName2 = typeName3;
        }
        catch (AssertionError err) {
            typeName2 = $this$tryBox;
        }
        return typeName2;
    }
}

