/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javah;

import com.sun.tools.javah.TypeSignature;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class Mangle {
    private Elements elems;
    private Types types;

    Mangle(Elements elems, Types types) {
        this.elems = elems;
        this.types = types;
    }

    public final String mangle(CharSequence name, int mtype) {
        StringBuilder result = new StringBuilder(100);
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char ch = name.charAt(i);
            if (Mangle.isalnum(ch)) {
                result.append(ch);
                continue;
            }
            if (ch == '.' && mtype == 1) {
                result.append('_');
                continue;
            }
            if (ch == '$' && mtype == 1) {
                result.append('_');
                result.append('_');
                continue;
            }
            if (ch == '_' && mtype == 2) {
                result.append('_');
                continue;
            }
            if (ch == '_' && mtype == 1) {
                result.append('_');
                continue;
            }
            if (mtype == 4) {
                String esc = null;
                if (ch == '_') {
                    esc = "_1";
                } else if (ch == '.') {
                    esc = "_";
                } else if (ch == ';') {
                    esc = "_2";
                } else if (ch == '[') {
                    esc = "_3";
                }
                if (esc != null) {
                    result.append(esc);
                    continue;
                }
                result.append(this.mangleChar(ch));
                continue;
            }
            if (mtype == 5) {
                if (Mangle.isprint(ch)) {
                    result.append(ch);
                    continue;
                }
                result.append(this.mangleChar(ch));
                continue;
            }
            result.append(this.mangleChar(ch));
        }
        return result.toString();
    }

    public String mangleMethod(ExecutableElement method, TypeElement clazz, int mtype) throws TypeSignature.SignatureException {
        StringBuilder result = new StringBuilder(100);
        result.append("Java_");
        if (mtype == 6) {
            result.append(this.mangle(clazz.getQualifiedName(), 1));
            result.append('_');
            result.append(this.mangle(method.getSimpleName(), 3));
            result.append("_stub");
            return result.toString();
        }
        result.append(this.mangle(this.getInnerQualifiedName(clazz), 4));
        result.append('_');
        result.append(this.mangle(method.getSimpleName(), 4));
        if (mtype == 8) {
            result.append("__");
            String typesig = this.signature(method);
            TypeSignature newTypeSig = new TypeSignature(this.elems);
            String sig = newTypeSig.getTypeSignature(typesig, method.getReturnType());
            sig = sig.substring(1);
            sig = sig.substring(0, sig.lastIndexOf(41));
            sig = sig.replace('/', '.');
            result.append(this.mangle(sig, 4));
        }
        return result.toString();
    }

    private String getInnerQualifiedName(TypeElement clazz) {
        return this.elems.getBinaryName(clazz).toString();
    }

    public final String mangleChar(char ch) {
        int i;
        String s = Integer.toHexString(ch);
        int nzeros = 5 - s.length();
        char[] result = new char[6];
        result[0] = 95;
        for (i = 1; i <= nzeros; ++i) {
            result[i] = 48;
        }
        i = nzeros + 1;
        int j = 0;
        while (i < 6) {
            result[i] = s.charAt(j);
            ++i;
            ++j;
        }
        return new String(result);
    }

    private String signature(ExecutableElement e) {
        StringBuilder sb = new StringBuilder();
        String sep = "(";
        for (VariableElement variableElement : e.getParameters()) {
            sb.append(sep);
            sb.append(this.types.erasure(variableElement.asType()).toString());
            sep = ",";
        }
        sb.append(")");
        return sb.toString();
    }

    private static boolean isalnum(char ch) {
        return ch <= '\u007f' && (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9');
    }

    private static boolean isprint(char ch) {
        return ch >= ' ' && ch <= '~';
    }

    public static class Type {
        public static final int CLASS = 1;
        public static final int FIELDSTUB = 2;
        public static final int FIELD = 3;
        public static final int JNI = 4;
        public static final int SIGNATURE = 5;
        public static final int METHOD_JDK_1 = 6;
        public static final int METHOD_JNI_SHORT = 7;
        public static final int METHOD_JNI_LONG = 8;
    }
}

