/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.api;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.DocSourcePositions;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreeScanner;
import com.sun.source.util.DocTrees;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.api.JavacScope;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.MemberEnter;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.file.BaseFileManager;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.parser.DocCommentParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.DocCommentTable;
import com.sun.tools.javac.tree.DocTreeMaker;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeCopier;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.Position;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.BreakIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.ForwardingFileObject;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class JavacTrees
extends DocTrees {
    private Resolve resolve;
    private Enter enter;
    private Log log;
    private MemberEnter memberEnter;
    private Attr attr;
    private TreeMaker treeMaker;
    private JavacElements elements;
    private JavacTaskImpl javacTaskImpl;
    private Names names;
    private Types types;
    private DocTreeMaker docTreeMaker;
    private BreakIterator breakIterator = null;
    private JavaFileManager fileManager;
    private ParserFactory parser;
    private Symtab syms;
    private Map<JavaFileObject, Symbol.PackageSymbol> javaFileObjectToPackageMap;
    Types.TypeRelation fuzzyMatcher = new Types.TypeRelation(){

        @Override
        public Boolean visitType(Type t, Type s) {
            if (t == s) {
                return true;
            }
            if (s.isPartial()) {
                return (Boolean)this.visit(s, t);
            }
            switch (t.getTag()) {
                case BYTE: 
                case CHAR: 
                case SHORT: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case VOID: 
                case BOT: 
                case NONE: {
                    return t.hasTag(s.getTag());
                }
            }
            throw new AssertionError((Object)("fuzzyMatcher " + (Object)((Object)t.getTag())));
        }

        @Override
        public Boolean visitArrayType(Type.ArrayType t, Type s) {
            if (t == s) {
                return true;
            }
            if (s.isPartial()) {
                return (Boolean)this.visit(s, t);
            }
            return s.hasTag(TypeTag.ARRAY) && (Boolean)this.visit(t.elemtype, JavacTrees.this.types.elemtype(s)) != false;
        }

        @Override
        public Boolean visitClassType(Type.ClassType t, Type s) {
            if (t == s) {
                return true;
            }
            if (s.isPartial()) {
                return (Boolean)this.visit(s, t);
            }
            return t.tsym == s.tsym;
        }

        @Override
        public Boolean visitErrorType(Type.ErrorType t, Type s) {
            return s.hasTag(TypeTag.CLASS) && t.tsym.name == ((Type.ClassType)s).tsym.name;
        }
    };

    public static JavacTrees instance(JavaCompiler.CompilationTask task) {
        if (!(task instanceof BasicJavacTask)) {
            throw new IllegalArgumentException();
        }
        return JavacTrees.instance(((BasicJavacTask)task).getContext());
    }

    public static JavacTrees instance(ProcessingEnvironment env) {
        if (!(env instanceof JavacProcessingEnvironment)) {
            throw new IllegalArgumentException();
        }
        return JavacTrees.instance(((JavacProcessingEnvironment)env).getContext());
    }

    public static JavacTrees instance(Context context) {
        JavacTrees instance = context.get(JavacTrees.class);
        if (instance == null) {
            instance = new JavacTrees(context);
        }
        return instance;
    }

    protected JavacTrees(Context context) {
        this.javaFileObjectToPackageMap = new HashMap<JavaFileObject, Symbol.PackageSymbol>();
        context.put(JavacTrees.class, this);
        this.init(context);
    }

    public void updateContext(Context context) {
        this.init(context);
    }

    private void init(Context context) {
        this.attr = Attr.instance(context);
        this.enter = Enter.instance(context);
        this.elements = JavacElements.instance(context);
        this.log = Log.instance(context);
        this.resolve = Resolve.instance(context);
        this.treeMaker = TreeMaker.instance(context);
        this.memberEnter = MemberEnter.instance(context);
        this.names = Names.instance(context);
        this.types = Types.instance(context);
        this.docTreeMaker = DocTreeMaker.instance(context);
        this.parser = ParserFactory.instance(context);
        this.syms = Symtab.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        JavacTask t = context.get(JavacTask.class);
        if (t instanceof JavacTaskImpl) {
            this.javacTaskImpl = (JavacTaskImpl)t;
        }
    }

    @Override
    public BreakIterator getBreakIterator() {
        return this.breakIterator;
    }

    @Override
    public DocSourcePositions getSourcePositions() {
        return new DocSourcePositions(){

            @Override
            public long getStartPosition(CompilationUnitTree file, Tree tree) {
                return TreeInfo.getStartPos((JCTree)tree);
            }

            @Override
            public long getEndPosition(CompilationUnitTree file, Tree tree) {
                EndPosTable endPosTable = ((JCTree.JCCompilationUnit)file).endPositions;
                return TreeInfo.getEndPos((JCTree)tree, endPosTable);
            }

            @Override
            public long getStartPosition(CompilationUnitTree file, DocCommentTree comment, DocTree tree) {
                return ((DCTree)tree).getSourcePosition((DCTree.DCDocComment)comment);
            }

            @Override
            public long getEndPosition(CompilationUnitTree file, DocCommentTree comment, DocTree tree) {
                int endPos;
                DCTree.DCDocComment dcComment = (DCTree.DCDocComment)comment;
                if (tree instanceof DCTree.DCEndPosTree && (endPos = ((DCTree.DCEndPosTree)tree).getEndPos(dcComment)) != -1) {
                    return endPos;
                }
                int correction = 0;
                switch (tree.getKind()) {
                    case TEXT: {
                        DCTree.DCText text = (DCTree.DCText)tree;
                        return dcComment.comment.getSourcePos(text.pos + text.text.length());
                    }
                    case ERRONEOUS: {
                        DCTree.DCErroneous err = (DCTree.DCErroneous)tree;
                        return dcComment.comment.getSourcePos(err.pos + err.body.length());
                    }
                    case IDENTIFIER: {
                        DCTree.DCIdentifier ident = (DCTree.DCIdentifier)tree;
                        return dcComment.comment.getSourcePos(ident.pos + (ident.name != ((JavacTrees)JavacTrees.this).names.error ? ident.name.length() : 0));
                    }
                    case PARAM: {
                        DCTree.DCParam param = (DCTree.DCParam)tree;
                        if (param.isTypeParameter && param.getDescription().isEmpty()) {
                            correction = 1;
                        }
                    }
                    case AUTHOR: 
                    case DEPRECATED: 
                    case RETURN: 
                    case SEE: 
                    case SERIAL: 
                    case SERIAL_DATA: 
                    case SERIAL_FIELD: 
                    case SINCE: 
                    case THROWS: 
                    case UNKNOWN_BLOCK_TAG: 
                    case VERSION: {
                        DocTree last = JavacTrees.this.getLastChild(tree);
                        if (last != null) {
                            return this.getEndPosition(file, comment, last) + (long)correction;
                        }
                        DCTree.DCBlockTag block = (DCTree.DCBlockTag)tree;
                        return dcComment.comment.getSourcePos(block.pos + block.getTagName().length() + 1);
                    }
                }
                DocTree last = JavacTrees.this.getLastChild(tree);
                if (last != null) {
                    return this.getEndPosition(file, comment, last);
                }
                return -1L;
            }
        };
    }

    @Override
    public DocTreeMaker getDocTreeFactory() {
        return this.docTreeMaker;
    }

    private DocTree getLastChild(DocTree tree) {
        final DocTree[] last = new DocTree[]{null};
        tree.accept(new DocTreeScanner<Void, Void>(){

            @Override
            public Void scan(DocTree node, Void p) {
                if (node != null) {
                    last[0] = node;
                }
                return null;
            }
        }, null);
        return last[0];
    }

    @Override
    public JCTree.JCClassDecl getTree(TypeElement element) {
        return (JCTree.JCClassDecl)this.getTree((Element)element);
    }

    @Override
    public JCTree.JCMethodDecl getTree(ExecutableElement method) {
        return (JCTree.JCMethodDecl)this.getTree((Element)method);
    }

    @Override
    public JCTree getTree(Element element) {
        return this.getTree(element, null);
    }

    @Override
    public JCTree getTree(Element e, AnnotationMirror a) {
        return this.getTree(e, a, null);
    }

    @Override
    public JCTree getTree(Element e, AnnotationMirror a, AnnotationValue v) {
        Pair<JCTree, JCTree.JCCompilationUnit> treeTopLevel = this.elements.getTreeAndTopLevel(e, a, v);
        if (treeTopLevel == null) {
            return null;
        }
        return (JCTree)treeTopLevel.fst;
    }

    @Override
    public TreePath getPath(CompilationUnitTree unit, Tree node) {
        return TreePath.getPath(unit, node);
    }

    @Override
    public TreePath getPath(Element e) {
        return this.getPath(e, null, null);
    }

    @Override
    public TreePath getPath(Element e, AnnotationMirror a) {
        return this.getPath(e, a, null);
    }

    @Override
    public TreePath getPath(Element e, AnnotationMirror a, AnnotationValue v) {
        Pair<JCTree, JCTree.JCCompilationUnit> treeTopLevel = this.elements.getTreeAndTopLevel(e, a, v);
        if (treeTopLevel == null) {
            return null;
        }
        return TreePath.getPath((CompilationUnitTree)treeTopLevel.snd, (Tree)treeTopLevel.fst);
    }

    @Override
    public Symbol getElement(TreePath path) {
        JCTree tree = (JCTree)path.getLeaf();
        Symbol sym = TreeInfo.symbolFor(tree);
        if (sym == null && TreeInfo.isDeclaration(tree)) {
            for (TreePath p = path; p != null; p = p.getParentPath()) {
                JCTree t = (JCTree)p.getLeaf();
                if (!t.hasTag(JCTree.Tag.CLASSDEF)) continue;
                JCTree.JCClassDecl ct2 = (JCTree.JCClassDecl)t;
                if (ct2.sym == null) continue;
                if ((ct2.sym.flags_field & 0x10000000L) == 0L) break;
                this.attr.attribClass(ct2.pos(), ct2.sym);
                sym = TreeInfo.symbolFor(tree);
                break;
            }
        }
        return sym;
    }

    @Override
    public Element getElement(DocTreePath path) {
        DocTree forTree = path.getLeaf();
        if (forTree instanceof DCTree.DCReference) {
            return this.attributeDocReference(path.getTreePath(), (DCTree.DCReference)forTree);
        }
        if (forTree instanceof DCTree.DCIdentifier && path.getParentPath().getLeaf() instanceof DCTree.DCParam) {
            return this.attributeParamIdentifier(path.getTreePath(), (DCTree.DCParam)path.getParentPath().getLeaf());
        }
        return null;
    }

    @Override
    public java.util.List<DocTree> getFirstSentence(java.util.List<? extends DocTree> list) {
        return this.docTreeMaker.getFirstSentence(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Symbol attributeDocReference(TreePath path, DCTree.DCReference ref) {
        Env<AttrContext> env = this.getAttrContext(path);
        Log.DeferredDiagnosticHandler deferredDiagnosticHandler = new Log.DeferredDiagnosticHandler(this.log);
        try {
            Symbol.VarSymbol vsym;
            void var7_15;
            Symbol.MethodSymbol msym;
            Object tree;
            void var5_8;
            Name memberName;
            if (ref.qualifierExpression == null) {
                Symbol.ClassSymbol classSymbol = env.enclClass.sym;
                memberName = (Name)ref.memberName;
            } else {
                Type type = this.attr.attribType(ref.qualifierExpression, env);
                if (type.isErroneous()) {
                    if (ref.memberName != null) {
                        Symbol pck = null;
                        return pck;
                    }
                    Symbol.PackageSymbol pck = this.elements.getPackageElement(ref.qualifierExpression.toString());
                    if (pck != null) {
                        Symbol.PackageSymbol packageSymbol = pck;
                        return packageSymbol;
                    }
                    if (!ref.qualifierExpression.hasTag(JCTree.Tag.IDENT)) {
                        Symbol symbol = null;
                        return symbol;
                    }
                    Symbol.ClassSymbol classSymbol = env.enclClass.sym;
                    memberName = ((JCTree.JCIdent)ref.qualifierExpression).name;
                } else {
                    Symbol.TypeSymbol typeSymbol = type.tsym;
                    memberName = (Name)ref.memberName;
                }
            }
            if (memberName == null) {
                void var7_12 = var5_8;
                return var7_12;
            }
            if (ref.paramTypes == null) {
                Object var7_13 = null;
            } else {
                ListBuffer<Type> lb = new ListBuffer<Type>();
                List l = (List)ref.paramTypes;
                while (l.nonEmpty()) {
                    tree = (JCTree)l.head;
                    Type type = this.attr.attribType((JCTree)tree, env);
                    lb.add(type);
                    l = l.tail;
                }
                List list = lb.toList();
            }
            Symbol.ClassSymbol sym = (Symbol.ClassSymbol)this.types.cvarUpperBound((Type)var5_8.type).tsym;
            Symbol.MethodSymbol methodSymbol = msym = memberName == sym.name ? this.findConstructor(sym, (List<Type>)var7_15) : this.findMethod(sym, memberName, (List<Type>)var7_15);
            if (var7_15 != null) {
                tree = msym;
                return tree;
            }
            Symbol.VarSymbol varSymbol = vsym = ref.paramTypes != null ? null : this.findField(sym, memberName);
            if (vsym != null && (msym == null || this.types.isSubtypeUnchecked((Type)vsym.enclClass().asType(), (Type)msym.enclClass().asType()))) {
                Symbol.VarSymbol varSymbol2 = vsym;
                return varSymbol2;
            }
            Symbol.MethodSymbol methodSymbol2 = msym;
            return methodSymbol2;
        }
        catch (Abort abort) {
            Symbol symbol = null;
            return symbol;
        }
        finally {
            this.log.popDiagnosticHandler(deferredDiagnosticHandler);
        }
    }

    private Symbol attributeParamIdentifier(TreePath path, DCTree.DCParam ptag) {
        Symbol javadocSymbol = this.getElement(path);
        if (javadocSymbol == null) {
            return null;
        }
        ElementKind kind = javadocSymbol.getKind();
        java.util.List params = List.nil();
        if (kind == ElementKind.METHOD || kind == ElementKind.CONSTRUCTOR) {
            Symbol.MethodSymbol ee = (Symbol.MethodSymbol)javadocSymbol;
            params = ptag.isTypeParameter() ? ee.getTypeParameters() : ee.getParameters();
        } else if (kind.isClass() || kind.isInterface()) {
            Symbol.ClassSymbol te = (Symbol.ClassSymbol)javadocSymbol;
            params = te.getTypeParameters();
        }
        for (Symbol param : params) {
            if (param.getSimpleName() != ptag.getName().getName()) continue;
            return param;
        }
        return null;
    }

    private Symbol.VarSymbol findField(Symbol.ClassSymbol tsym, Name fieldName) {
        return this.searchField(tsym, fieldName, new HashSet<Symbol.ClassSymbol>());
    }

    private Symbol.VarSymbol searchField(Symbol.ClassSymbol tsym, Name fieldName, Set<Symbol.ClassSymbol> searched) {
        List intfs;
        Symbol.VarSymbol vsym;
        Symbol.VarSymbol vsym2;
        if (searched.contains(tsym)) {
            return null;
        }
        searched.add(tsym);
        for (Symbol sym : tsym.members().getSymbolsByName(fieldName)) {
            if (sym.kind != Kinds.Kind.VAR) continue;
            return (Symbol.VarSymbol)sym;
        }
        Symbol.ClassSymbol encl = tsym.owner.enclClass();
        if (encl != null && (vsym2 = this.searchField(encl, fieldName, searched)) != null) {
            return vsym2;
        }
        Type superclass = tsym.getSuperclass();
        if (superclass.tsym != null && (vsym = this.searchField((Symbol.ClassSymbol)superclass.tsym, fieldName, searched)) != null) {
            return vsym;
        }
        List l = intfs = tsym.getInterfaces();
        while (l.nonEmpty()) {
            Symbol.VarSymbol vsym3;
            Type intf = (Type)l.head;
            if (!intf.isErroneous() && (vsym3 = this.searchField((Symbol.ClassSymbol)intf.tsym, fieldName, searched)) != null) {
                return vsym3;
            }
            l = l.tail;
        }
        return null;
    }

    Symbol.MethodSymbol findConstructor(Symbol.ClassSymbol tsym, List<Type> paramTypes) {
        for (Symbol sym : tsym.members().getSymbolsByName(this.names.init)) {
            if (sym.kind != Kinds.Kind.MTH || !this.hasParameterTypes((Symbol.MethodSymbol)sym, paramTypes)) continue;
            return (Symbol.MethodSymbol)sym;
        }
        return null;
    }

    private Symbol.MethodSymbol findMethod(Symbol.ClassSymbol tsym, Name methodName, List<Type> paramTypes) {
        return this.searchMethod(tsym, methodName, paramTypes, new HashSet<Symbol.ClassSymbol>());
    }

    private Symbol.MethodSymbol searchMethod(Symbol.ClassSymbol tsym, Name methodName, List<Type> paramTypes, Set<Symbol.ClassSymbol> searched) {
        Symbol.MethodSymbol msym;
        List intfs;
        Symbol.MethodSymbol msym2;
        if (methodName == this.names.init) {
            return null;
        }
        if (searched.contains(tsym)) {
            return null;
        }
        searched.add(tsym);
        if (paramTypes == null) {
            Object lastFound = null;
            for (Symbol sym : tsym.members().getSymbolsByName(methodName)) {
                if (sym.kind != Kinds.Kind.MTH || sym.name != methodName) continue;
                lastFound = (Symbol.MethodSymbol)sym;
            }
            if (lastFound != null) {
                return lastFound;
            }
        } else {
            for (Symbol sym : tsym.members().getSymbolsByName(methodName)) {
                if (sym == null || sym.kind != Kinds.Kind.MTH || !this.hasParameterTypes((Symbol.MethodSymbol)sym, paramTypes)) continue;
                return (Symbol.MethodSymbol)sym;
            }
        }
        Type superclass = tsym.getSuperclass();
        if (superclass.tsym != null && (msym2 = this.searchMethod((Symbol.ClassSymbol)superclass.tsym, methodName, paramTypes, searched)) != null) {
            return msym2;
        }
        List l = intfs = tsym.getInterfaces();
        while (l.nonEmpty()) {
            Symbol.MethodSymbol msym3;
            Type intf = (Type)l.head;
            if (!intf.isErroneous() && (msym3 = this.searchMethod((Symbol.ClassSymbol)intf.tsym, methodName, paramTypes, searched)) != null) {
                return msym3;
            }
            l = l.tail;
        }
        Symbol.ClassSymbol encl = tsym.owner.enclClass();
        if (encl != null && (msym = this.searchMethod(encl, methodName, paramTypes, searched)) != null) {
            return msym;
        }
        return null;
    }

    private boolean hasParameterTypes(Symbol.MethodSymbol method, List<Type> paramTypes) {
        if (paramTypes == null) {
            return true;
        }
        if (method.params().size() != paramTypes.size()) {
            return false;
        }
        List<Type> methodParamTypes = this.types.erasureRecursive((Type)method.asType()).getParameterTypes();
        return Type.isErroneous(paramTypes) ? this.fuzzyMatch(paramTypes, methodParamTypes) : this.types.isSameTypes(paramTypes, methodParamTypes);
    }

    boolean fuzzyMatch(List<Type> paramTypes, List<Type> methodParamTypes) {
        List<Type> l1 = paramTypes;
        List<Type> l2 = methodParamTypes;
        while (l1.nonEmpty()) {
            if (!this.fuzzyMatch((Type)l1.head, (Type)l2.head)) {
                return false;
            }
            l1 = l1.tail;
            l2 = l2.tail;
        }
        return true;
    }

    boolean fuzzyMatch(Type paramType, Type methodParamType) {
        Boolean b = (Boolean)this.fuzzyMatcher.visit(paramType, methodParamType);
        return b == Boolean.TRUE;
    }

    @Override
    public TypeMirror getTypeMirror(TreePath path) {
        Tree t = path.getLeaf();
        Type ty = ((JCTree)t).type;
        return ty == null ? null : ty.stripMetadataIfNeeded();
    }

    @Override
    public JavacScope getScope(TreePath path) {
        return JavacScope.create(this.getAttrContext(path));
    }

    @Override
    public String getDocComment(TreePath path) {
        CompilationUnitTree t = path.getCompilationUnit();
        Tree leaf = path.getLeaf();
        if (t instanceof JCTree.JCCompilationUnit && leaf instanceof JCTree) {
            JCTree.JCCompilationUnit cu = (JCTree.JCCompilationUnit)t;
            if (cu.docComments != null) {
                return cu.docComments.getCommentText((JCTree)leaf);
            }
        }
        return null;
    }

    @Override
    public DocCommentTree getDocCommentTree(TreePath path) {
        CompilationUnitTree t = path.getCompilationUnit();
        Tree leaf = path.getLeaf();
        if (t instanceof JCTree.JCCompilationUnit && leaf instanceof JCTree) {
            JCTree.JCCompilationUnit cu = (JCTree.JCCompilationUnit)t;
            if (cu.docComments != null) {
                return cu.docComments.getCommentTree((JCTree)leaf);
            }
        }
        return null;
    }

    @Override
    public DocCommentTree getDocCommentTree(Element e) {
        TreePath path = this.getPath(e);
        if (path == null) {
            return null;
        }
        return this.getDocCommentTree(path);
    }

    @Override
    public DocCommentTree getDocCommentTree(Element e, String relativeFileName) throws IOException {
        PackageElement pkg = this.elements.getPackageOf(e);
        FileObject fileForInput = this.fileManager.getFileForInput(StandardLocation.SOURCE_PATH, pkg.getQualifiedName().toString(), relativeFileName);
        if (fileForInput == null) {
            throw new FileNotFoundException(relativeFileName);
        }
        return this.getDocCommentTree(fileForInput);
    }

    @Override
    public boolean isAccessible(Scope scope, TypeElement type) {
        if (scope instanceof JavacScope && type instanceof Symbol.ClassSymbol) {
            Env<AttrContext> env = ((JavacScope)scope).env;
            return this.resolve.isAccessible(env, (Symbol.ClassSymbol)type, true);
        }
        return false;
    }

    @Override
    public boolean isAccessible(Scope scope, Element member, DeclaredType type) {
        if (scope instanceof JavacScope && member instanceof Symbol && type instanceof Type) {
            Env<AttrContext> env = ((JavacScope)scope).env;
            return this.resolve.isAccessible(env, (Type)((Object)type), (Symbol)member, true);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Env<AttrContext> getAttrContext(TreePath path) {
        if (!(path.getLeaf() instanceof JCTree)) {
            throw new IllegalArgumentException();
        }
        if (this.javacTaskImpl != null) {
            this.javacTaskImpl.enter(null);
        }
        JCTree.JCCompilationUnit unit = (JCTree.JCCompilationUnit)path.getCompilationUnit();
        Copier copier = this.createCopier(this.treeMaker.forToplevel(unit));
        Env<AttrContext> env = null;
        JCTree.JCMethodDecl method = null;
        JCTree.JCVariableDecl field = null;
        List<Tree> l = List.nil();
        for (TreePath p = path; p != null; p = p.getParentPath()) {
            l = l.prepend(p.getLeaf());
        }
        while (l.nonEmpty()) {
            Tree tree = (Tree)l.head;
            switch (tree.getKind()) {
                case COMPILATION_UNIT: {
                    env = this.enter.getTopLevelEnv((JCTree.JCCompilationUnit)tree);
                    break;
                }
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    env = this.enter.getClassEnv(((JCTree.JCClassDecl)tree).sym);
                    break;
                }
                case METHOD: {
                    method = (JCTree.JCMethodDecl)tree;
                    env = this.memberEnter.getMethodEnv(method, env);
                    break;
                }
                case VARIABLE: {
                    field = (JCTree.JCVariableDecl)tree;
                    break;
                }
                case BLOCK: {
                    if (method != null) {
                        try {
                            Assert.check(method.body == tree);
                            method.body = copier.copy((JCTree.JCBlock)tree, (JCTree)path.getLeaf());
                            env = this.attribStatToTree(method.body, env, copier.leafCopy);
                        }
                        finally {
                            method.body = (JCTree.JCBlock)tree;
                        }
                    } else {
                        JCTree.JCBlock body = copier.copy((JCTree.JCBlock)tree, (JCTree)path.getLeaf());
                        env = this.attribStatToTree(body, env, copier.leafCopy);
                    }
                    return env;
                }
                default: {
                    if (field == null || field.getInitializer() != tree) break;
                    env = this.memberEnter.getInitEnv(field, env);
                    JCTree.JCExpression expr = copier.copy((JCTree.JCExpression)tree, (JCTree)path.getLeaf());
                    env = this.attribExprToTree(expr, env, copier.leafCopy);
                    return env;
                }
            }
            l = l.tail;
        }
        return field != null ? this.memberEnter.getInitEnv(field, env) : env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Env<AttrContext> attribStatToTree(JCTree stat, Env<AttrContext> env, JCTree tree) {
        JavaFileObject prev = this.log.useSource(env.toplevel.sourcefile);
        try {
            Env<AttrContext> env2 = this.attr.attribStatToTree(stat, env, tree);
            return env2;
        }
        finally {
            this.log.useSource(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Env<AttrContext> attribExprToTree(JCTree.JCExpression expr, Env<AttrContext> env, JCTree tree) {
        JavaFileObject prev = this.log.useSource(env.toplevel.sourcefile);
        try {
            Env<AttrContext> env2 = this.attr.attribExprToTree(expr, env, tree);
            return env2;
        }
        finally {
            this.log.useSource(prev);
        }
    }

    static JavaFileObject asJavaFileObject(FileObject fileObject) {
        JavaFileObject jfo = null;
        if (fileObject instanceof JavaFileObject) {
            jfo = (JavaFileObject)fileObject;
            JavacTrees.checkHtmlKind(fileObject, JavaFileObject.Kind.HTML);
            return jfo;
        }
        JavacTrees.checkHtmlKind(fileObject);
        jfo = new HtmlFileObject(fileObject);
        return jfo;
    }

    private static void checkHtmlKind(FileObject fileObject) {
        JavacTrees.checkHtmlKind(fileObject, BaseFileManager.getKind(fileObject.getName()));
    }

    private static void checkHtmlKind(FileObject fileObject, JavaFileObject.Kind kind) {
        if (kind != JavaFileObject.Kind.HTML) {
            throw new IllegalArgumentException("HTML file expected:" + fileObject.getName());
        }
    }

    @Override
    public DocCommentTree getDocCommentTree(final FileObject fileObject) {
        JavaFileObject jfo = JavacTrees.asJavaFileObject(fileObject);
        DiagnosticSource diagSource = new DiagnosticSource(jfo, this.log);
        Tokens.Comment comment = new Tokens.Comment(){
            int offset = 0;

            @Override
            public String getText() {
                try {
                    CharSequence rawDoc = fileObject.getCharContent(true);
                    Pattern bodyPat = Pattern.compile("(?is).*?<body\\b[^>]*>(.*)</body\\b.*");
                    Matcher m = bodyPat.matcher(rawDoc);
                    if (m.matches()) {
                        this.offset = m.end(1);
                        return m.group(1);
                    }
                    return "";
                }
                catch (IOException iOException) {
                    return "";
                }
            }

            @Override
            public int getSourcePos(int index) {
                return this.offset + index;
            }

            @Override
            public Tokens.Comment.CommentStyle getStyle() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isDeprecated() {
                throw new UnsupportedOperationException();
            }
        };
        return new DocCommentParser(this.parser, diagSource, comment).parse();
    }

    @Override
    public DocTreePath getDocTreePath(FileObject fileObject) {
        JavaFileObject jfo = JavacTrees.asJavaFileObject(fileObject);
        DocCommentTree docCommentTree = this.getDocCommentTree(jfo);
        return new DocTreePath(this.makeTreePath(jfo, docCommentTree), docCommentTree);
    }

    @Override
    public void setBreakIterator(BreakIterator breakiterator) {
        this.breakIterator = breakiterator;
    }

    protected Copier createCopier(TreeMaker maker) {
        return new Copier(maker);
    }

    @Override
    public TypeMirror getOriginalType(ErrorType errorType) {
        if (errorType instanceof Type.ErrorType) {
            return ((Type.ErrorType)errorType).getOriginalType();
        }
        return Type.noType;
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence msg, Tree t, CompilationUnitTree root) {
        this.printMessage(kind, msg, ((JCTree)t).pos(), root);
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence msg, DocTree t, DocCommentTree c, CompilationUnitTree root) {
        this.printMessage(kind, msg, ((DCTree)t).pos((DCTree.DCDocComment)c), root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void printMessage(Diagnostic.Kind kind, CharSequence msg, JCDiagnostic.DiagnosticPosition pos, CompilationUnitTree root) {
        JavaFileObject oldSource = null;
        JavaFileObject newSource = null;
        newSource = root.getSourceFile();
        if (newSource == null) {
            pos = null;
        } else {
            oldSource = this.log.useSource(newSource);
        }
        try {
            switch (kind) {
                case ERROR: {
                    this.log.error(JCDiagnostic.DiagnosticFlag.MULTIPLE, pos, "proc.messager", msg.toString());
                    return;
                }
                case WARNING: {
                    this.log.warning(pos, "proc.messager", msg.toString());
                    return;
                }
                case MANDATORY_WARNING: {
                    this.log.mandatoryWarning(pos, "proc.messager", msg.toString());
                    return;
                }
                default: {
                    this.log.note(pos, "proc.messager", msg.toString());
                    return;
                }
            }
        }
        finally {
            if (oldSource != null) {
                this.log.useSource(oldSource);
            }
        }
    }

    @Override
    public TypeMirror getLub(CatchTree tree) {
        JCTree.JCCatch ct2 = (JCTree.JCCatch)tree;
        JCTree.JCVariableDecl v = ct2.param;
        if (v.type != null && v.type.getKind() == TypeKind.UNION) {
            Type.UnionClassType ut = (Type.UnionClassType)v.type;
            return ut.getLub();
        }
        return v.type;
    }

    public void putJavaFileObject(Symbol.PackageSymbol psym, JavaFileObject jfo) {
        this.javaFileObjectToPackageMap.putIfAbsent(jfo, psym);
    }

    private TreePath makeTreePath(final JavaFileObject jfo, final DocCommentTree dcTree) {
        JCTree.JCCompilationUnit jcCompilationUnit = new JCTree.JCCompilationUnit(List.nil()){

            public int getPos() {
                return 0;
            }

            public JavaFileObject getSourcefile() {
                return jfo;
            }

            @Override
            public Position.LineMap getLineMap() {
                try {
                    CharSequence content = jfo.getCharContent(true);
                    String s = content.toString();
                    return Position.makeLineMap(s.toCharArray(), s.length(), true);
                }
                catch (IOException iOException) {
                    return null;
                }
            }
        };
        Symbol.PackageSymbol psym = this.javaFileObjectToPackageMap.getOrDefault(jfo, this.syms.unnamedPackage);
        jcCompilationUnit.docComments = new DocCommentTable(){

            @Override
            public boolean hasComment(JCTree tree) {
                return false;
            }

            @Override
            public Tokens.Comment getComment(JCTree tree) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getCommentText(JCTree tree) {
                throw new UnsupportedOperationException();
            }

            @Override
            public DCTree.DCDocComment getCommentTree(JCTree tree) {
                return (DCTree.DCDocComment)dcTree;
            }

            @Override
            public void putComment(JCTree tree, Tokens.Comment c) {
                throw new UnsupportedOperationException();
            }
        };
        jcCompilationUnit.lineMap = jcCompilationUnit.getLineMap();
        jcCompilationUnit.namedImportScope = new Scope.NamedImportScope(psym, jcCompilationUnit.toplevelScope);
        jcCompilationUnit.packge = psym;
        jcCompilationUnit.starImportScope = null;
        jcCompilationUnit.sourcefile = jfo;
        jcCompilationUnit.starImportScope = new Scope.StarImportScope(psym);
        jcCompilationUnit.toplevelScope = Scope.WriteableScope.create(psym);
        return new TreePath(jcCompilationUnit);
    }

    protected static class Copier
    extends TreeCopier<JCTree> {
        JCTree leafCopy = null;

        protected Copier(TreeMaker M) {
            super(M);
        }

        @Override
        public <T extends JCTree> T copy(T t, JCTree leaf) {
            T t2 = super.copy(t, leaf);
            if (t == leaf) {
                this.leafCopy = t2;
            }
            return t2;
        }
    }

    private static class HtmlFileObject
    extends ForwardingFileObject<FileObject>
    implements JavaFileObject {
        public HtmlFileObject(FileObject fileObject) {
            super(fileObject);
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return BaseFileManager.getKind(this.fileObject.getName());
        }

        @Override
        public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
            return false;
        }

        @Override
        public NestingKind getNestingKind() {
            return null;
        }

        @Override
        public Modifier getAccessLevel() {
            return null;
        }
    }
}

