/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.CommandSender;
import com.sun.tools.jdi.FieldImpl;
import com.sun.tools.jdi.InvokableTypeImpl;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.MethodImpl;
import com.sun.tools.jdi.ObjectReferenceImpl;
import com.sun.tools.jdi.PacketStream;
import com.sun.tools.jdi.ReferenceTypeImpl;
import com.sun.tools.jdi.ThreadReferenceImpl;
import com.sun.tools.jdi.ValueImpl;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.util.ArrayList;
import java.util.List;

public final class ClassTypeImpl
extends InvokableTypeImpl
implements ClassType {
    private boolean cachedSuperclass = false;
    private ClassType superclass = null;
    private int lastLine = -1;
    private List<InterfaceType> interfaces = null;

    protected ClassTypeImpl(VirtualMachine aVm, long aRef) {
        super(aVm, aRef);
    }

    @Override
    public ClassType superclass() {
        if (!this.cachedSuperclass) {
            ClassTypeImpl sup = null;
            try {
                sup = JDWP.ClassType.Superclass.process((VirtualMachineImpl)this.vm, (ClassTypeImpl)this).superclass;
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
            if (sup != null) {
                this.superclass = sup;
            }
            this.cachedSuperclass = true;
        }
        return this.superclass;
    }

    @Override
    public List<InterfaceType> interfaces() {
        if (this.interfaces == null) {
            this.interfaces = this.getInterfaces();
        }
        return this.interfaces;
    }

    @Override
    public List<InterfaceType> allInterfaces() {
        return this.getAllInterfaces();
    }

    @Override
    public List<ClassType> subclasses() {
        ArrayList<ClassType> subs = new ArrayList<ClassType>();
        for (ReferenceType refType : this.vm.allClasses()) {
            ClassType clazz;
            ClassType superclass;
            if (!(refType instanceof ClassType) || (superclass = (clazz = (ClassType)refType).superclass()) == null || !superclass.equals(this)) continue;
            subs.add((ClassType)refType);
        }
        return subs;
    }

    @Override
    public boolean isEnum() {
        ClassType superclass = this.superclass();
        return superclass != null && superclass.name().equals("java.lang.Enum");
    }

    @Override
    public void setValue(Field field, Value value) throws InvalidTypeException, ClassNotLoadedException {
        block5: {
            this.validateMirror(field);
            this.validateMirrorOrNull(value);
            this.validateFieldSet(field);
            if (!field.isStatic()) {
                throw new IllegalArgumentException("Must set non-static field through an instance");
            }
            try {
                JDWP.ClassType.SetValues.FieldValue[] values = new JDWP.ClassType.SetValues.FieldValue[]{new JDWP.ClassType.SetValues.FieldValue(((FieldImpl)field).ref(), ValueImpl.prepareForAssignment(value, (FieldImpl)field))};
                try {
                    JDWP.ClassType.SetValues.process(this.vm, this, values);
                }
                catch (JDWPException exc) {
                    throw exc.toJDIException();
                }
            }
            catch (ClassNotLoadedException e) {
                if (value == null) break block5;
                throw e;
            }
        }
    }

    PacketStream sendNewInstanceCommand(final ThreadReferenceImpl thread, final MethodImpl method, final ValueImpl[] args, final int options) {
        CommandSender sender = new CommandSender(){

            @Override
            public PacketStream send() {
                return JDWP.ClassType.NewInstance.enqueueCommand(ClassTypeImpl.this.vm, ClassTypeImpl.this, thread, method.ref(), args, options);
            }
        };
        PacketStream stream = (options & 1) != 0 ? thread.sendResumingCommand(sender) : this.vm.sendResumingCommand(sender);
        return stream;
    }

    @Override
    public ObjectReference newInstance(ThreadReference threadIntf, Method methodIntf, List<? extends Value> origArguments, int options) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        this.validateMirror(threadIntf);
        this.validateMirror(methodIntf);
        this.validateMirrorsOrNulls(origArguments);
        MethodImpl method = (MethodImpl)methodIntf;
        ThreadReferenceImpl thread = (ThreadReferenceImpl)threadIntf;
        this.validateConstructorInvocation(method);
        List<Value> arguments = method.validateAndPrepareArgumentsForInvoke(origArguments);
        ValueImpl[] args = arguments.toArray(new ValueImpl[0]);
        JDWP.ClassType.NewInstance ret = null;
        try {
            PacketStream stream = this.sendNewInstanceCommand(thread, method, args, options);
            ret = JDWP.ClassType.NewInstance.waitForReply(this.vm, stream);
        }
        catch (JDWPException exc) {
            if (exc.errorCode() == 10) {
                throw new IncompatibleThreadStateException();
            }
            throw exc.toJDIException();
        }
        if ((options & 1) == 0) {
            this.vm.notifySuspend();
        }
        if (ret.exception != null) {
            throw new InvocationException(ret.exception);
        }
        return ret.newObject;
    }

    @Override
    public Method concreteMethodByName(String name, String signature) {
        Method method = null;
        for (Method candidate : this.visibleMethods()) {
            if (!candidate.name().equals(name) || !candidate.signature().equals(signature) || candidate.isAbstract()) continue;
            method = candidate;
            break;
        }
        return method;
    }

    void validateConstructorInvocation(Method method) throws InvalidTypeException, InvocationException {
        ReferenceTypeImpl declType = (ReferenceTypeImpl)method.declaringType();
        if (!declType.equals(this)) {
            throw new IllegalArgumentException("Invalid constructor");
        }
        if (!method.isConstructor()) {
            throw new IllegalArgumentException("Cannot create instance with non-constructor");
        }
    }

    @Override
    public String toString() {
        return "class " + this.name() + " (" + this.loaderString() + ")";
    }

    @Override
    CommandSender getInvokeMethodSender(ThreadReferenceImpl thread, MethodImpl method, ValueImpl[] args, int options) {
        return () -> JDWP.ClassType.InvokeMethod.enqueueCommand(this.vm, this, thread, method.ref(), args, options);
    }

    @Override
    InvokableTypeImpl.InvocationResult waitForReply(PacketStream stream) throws JDWPException {
        return new IResult(JDWP.ClassType.InvokeMethod.waitForReply(this.vm, stream));
    }

    @Override
    boolean canInvoke(Method method) {
        return ((ReferenceTypeImpl)method.declaringType()).isAssignableFrom(this);
    }

    private static class IResult
    implements InvokableTypeImpl.InvocationResult {
        private final JDWP.ClassType.InvokeMethod rslt;

        public IResult(JDWP.ClassType.InvokeMethod rslt) {
            this.rslt = rslt;
        }

        @Override
        public ObjectReferenceImpl getException() {
            return this.rslt.exception;
        }

        @Override
        public ValueImpl getResult() {
            return this.rslt.returnValue;
        }
    }
}

