/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.api;

import com.sun.tools.javac.api.ClientCodeWrapper;
import com.sun.tools.javac.file.BaseFileManager;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.tools.DiagnosticListener;
import javax.tools.DocumentationTool;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import jdk.javadoc.internal.api.JavadocTaskImpl;
import jdk.javadoc.internal.tool.Main;
import jdk.javadoc.internal.tool.ToolOption;

public class JavadocTool
implements DocumentationTool {
    @Override
    public DocumentationTool.DocumentationTask getTask(Writer out, JavaFileManager fileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Class<?> docletClass, Iterable<String> options, Iterable<? extends JavaFileObject> compilationUnits) {
        Context context = new Context();
        return this.getTask(out, fileManager, diagnosticListener, docletClass, options, compilationUnits, context);
    }

    public DocumentationTool.DocumentationTask getTask(Writer out, JavaFileManager fileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Class<?> docletClass, Iterable<String> options, Iterable<? extends JavaFileObject> compilationUnits, Context context) {
        try {
            ClientCodeWrapper ccw = ClientCodeWrapper.instance(context);
            if (options != null) {
                for (String string : options) {
                    Objects.requireNonNull(string);
                }
            }
            if (compilationUnits != null) {
                compilationUnits = ccw.wrapJavaFileObjects(compilationUnits);
                for (JavaFileObject javaFileObject : compilationUnits) {
                    if (javaFileObject.getKind() == JavaFileObject.Kind.SOURCE) continue;
                    String kindMsg = "All compilation units must be of SOURCE kind";
                    throw new IllegalArgumentException("All compilation units must be of SOURCE kind");
                }
            }
            if (diagnosticListener != null) {
                context.put(DiagnosticListener.class, ccw.wrap(diagnosticListener));
            }
            if (out == null) {
                context.put(Log.outKey, new PrintWriter(System.err, true));
            } else if (out instanceof PrintWriter) {
                context.put(Log.outKey, (PrintWriter)out);
            } else {
                context.put(Log.outKey, new PrintWriter(out, true));
            }
            if (fileManager == null && (fileManager = this.getStandardFileManager(diagnosticListener, null, null)) instanceof BaseFileManager) {
                ((BaseFileManager)fileManager).autoClose = true;
            }
            fileManager = ccw.wrap(fileManager);
            context.put(JavaFileManager.class, fileManager);
            return new JavadocTaskImpl(context, docletClass, options, compilationUnits);
        }
        catch (ClientCodeException ex) {
            throw new RuntimeException(ex.getCause());
        }
    }

    @Override
    public StandardJavaFileManager getStandardFileManager(DiagnosticListener<? super JavaFileObject> diagnosticListener, Locale locale, Charset charset) {
        Context context = new Context();
        context.put(Locale.class, locale);
        if (diagnosticListener != null) {
            context.put(DiagnosticListener.class, diagnosticListener);
        }
        PrintWriter pw = charset == null ? new PrintWriter(System.err, true) : new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.err, charset), true);
        context.put(Log.outKey, pw);
        return new JavacFileManager(context, true, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(InputStream in, OutputStream out, OutputStream err, String ... arguments) {
        PrintWriter err_pw = new PrintWriter(err == null ? System.err : err, true);
        PrintWriter out_pw = new PrintWriter(out == null ? System.out : out);
        try {
            int n = Main.execute(arguments, err_pw);
            return n;
        }
        finally {
            err_pw.flush();
            out_pw.flush();
        }
    }

    @Override
    public Set<SourceVersion> getSourceVersions() {
        return Collections.unmodifiableSet(EnumSet.range(SourceVersion.RELEASE_3, SourceVersion.latest()));
    }

    @Override
    public int isSupportedOption(String option) {
        if (option == null) {
            throw new NullPointerException();
        }
        for (ToolOption o : ToolOption.values()) {
            if (!o.opt.equals(option)) continue;
            return o.hasArg ? 1 : 0;
        }
        return -1;
    }
}

