/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.toolkit.util.links;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor9;
import jdk.javadoc.internal.doclets.formats.html.LinkInfoImpl;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.util.Utils;
import jdk.javadoc.internal.doclets.toolkit.util.links.LinkInfo;

public abstract class LinkFactory {
    protected abstract Content newContent();

    public Content getLink(final LinkInfo linkInfo) {
        final Utils utils = ((LinkInfoImpl)linkInfo).configuration.utils;
        if (linkInfo.type != null) {
            SimpleTypeVisitor9<Content, LinkInfo> linkVisitor = new SimpleTypeVisitor9<Content, LinkInfo>(){
                TypeMirror componentType;
                Content link;
                int currentDepth;
                {
                    this.componentType = utils.getComponentType(linkInfo.type);
                    this.link = LinkFactory.this.newContent();
                    this.currentDepth = 0;
                }

                @Override
                protected Content defaultAction(TypeMirror type, LinkInfo linkInfo2) {
                    this.link.addContent(utils.getTypeName(type, false));
                    return this.link;
                }

                @Override
                public Content visitArray(ArrayType type, LinkInfo linkInfo2) {
                    ++this.currentDepth;
                    linkInfo2.type = type.getComponentType();
                    this.visit(linkInfo2.type, linkInfo2);
                    --this.currentDepth;
                    if (utils.isAnnotated(type)) {
                        linkInfo2.type = type;
                        this.link.addContent(" ");
                        this.link.addContent(LinkFactory.this.getTypeAnnotationLinks(linkInfo2));
                    }
                    if (linkInfo2.isVarArg && this.currentDepth == 0) {
                        this.link.addContent("...");
                    } else {
                        this.link.addContent("[]");
                    }
                    return this.link;
                }

                @Override
                public Content visitWildcard(WildcardType type, LinkInfo linkInfo2) {
                    TypeMirror superBound;
                    linkInfo2.isTypeBound = true;
                    this.link.addContent("?");
                    TypeMirror extendsBound = type.getExtendsBound();
                    if (extendsBound != null) {
                        this.link.addContent(" extends ");
                        LinkFactory.this.setBoundsLinkInfo(linkInfo2, extendsBound);
                        this.link.addContent(LinkFactory.this.getLink(linkInfo2));
                    }
                    if ((superBound = type.getSuperBound()) != null) {
                        this.link.addContent(" super ");
                        LinkFactory.this.setBoundsLinkInfo(linkInfo2, superBound);
                        this.link.addContent(LinkFactory.this.getLink(linkInfo2));
                    }
                    return this.link;
                }

                @Override
                public Content visitTypeVariable(TypeVariable type, LinkInfo linkInfo2) {
                    this.link.addContent(LinkFactory.this.getTypeAnnotationLinks(linkInfo2));
                    linkInfo2.isTypeBound = true;
                    TypeVariable typevariable = utils.isArrayType(type) ? (TypeVariable)this.componentType : type;
                    Element owner = typevariable.asElement().getEnclosingElement();
                    if (!linkInfo2.excludeTypeParameterLinks && utils.isTypeElement(owner)) {
                        linkInfo2.typeElement = (TypeElement)owner;
                        Content label = LinkFactory.this.newContent();
                        label.addContent(utils.getTypeName(type, false));
                        linkInfo2.label = label;
                        this.link.addContent(LinkFactory.this.getClassLink(linkInfo2));
                    } else {
                        this.link.addContent(utils.getTypeName(typevariable, false));
                    }
                    if (!linkInfo2.excludeTypeBounds) {
                        linkInfo2.excludeTypeBounds = true;
                        TypeParameterElement tpe = (TypeParameterElement)typevariable.asElement();
                        boolean more = false;
                        List<? extends TypeMirror> bounds = utils.getBounds(tpe);
                        for (TypeMirror typeMirror : bounds) {
                            if (bounds.size() == 1 && typeMirror.equals(utils.getObjectType()) && !utils.isAnnotated(typeMirror)) continue;
                            this.link.addContent(more ? " & " : " extends ");
                            LinkFactory.this.setBoundsLinkInfo(linkInfo2, typeMirror);
                            this.link.addContent(LinkFactory.this.getLink(linkInfo2));
                            more = true;
                        }
                    }
                    return this.link;
                }

                @Override
                public Content visitDeclared(DeclaredType type, LinkInfo linkInfo2) {
                    if (linkInfo2.isTypeBound && linkInfo2.excludeTypeBoundsLinks) {
                        this.link.addContent(utils.getTypeName(type, false));
                        this.link.addContent(LinkFactory.this.getTypeParameterLinks(linkInfo2));
                        return this.link;
                    }
                    this.link = LinkFactory.this.newContent();
                    this.link.addContent(LinkFactory.this.getTypeAnnotationLinks(linkInfo2));
                    linkInfo2.typeElement = utils.asTypeElement(type);
                    this.link.addContent(LinkFactory.this.getClassLink(linkInfo2));
                    if (linkInfo2.includeTypeAsSepLink) {
                        this.link.addContent(LinkFactory.this.getTypeParameterLinks(linkInfo2, false));
                    }
                    return this.link;
                }
            };
            return (Content)linkVisitor.visit(linkInfo.type, linkInfo);
        }
        if (linkInfo.typeElement != null) {
            Content link = this.newContent();
            link.addContent(this.getClassLink(linkInfo));
            if (linkInfo.includeTypeAsSepLink) {
                link.addContent(this.getTypeParameterLinks(linkInfo, false));
            }
            return link;
        }
        return null;
    }

    private void setBoundsLinkInfo(LinkInfo linkInfo, TypeMirror bound) {
        linkInfo.typeElement = null;
        linkInfo.label = null;
        linkInfo.type = bound;
    }

    protected abstract Content getClassLink(LinkInfo var1);

    protected abstract Content getTypeParameterLink(LinkInfo var1, TypeMirror var2);

    protected abstract Content getTypeAnnotationLink(LinkInfo var1, AnnotationMirror var2);

    public Content getTypeParameterLinks(LinkInfo linkInfo) {
        return this.getTypeParameterLinks(linkInfo, true);
    }

    public Content getTypeParameterLinks(LinkInfo linkInfo, boolean isClassLabel) {
        TypeMirror ctype;
        Utils utils = ((LinkInfoImpl)linkInfo).utils;
        Content links = this.newContent();
        ArrayList vars = new ArrayList();
        TypeMirror typeMirror = ctype = linkInfo.type != null ? utils.getComponentType(linkInfo.type) : null;
        if (linkInfo.executableElement != null) {
            linkInfo.executableElement.getTypeParameters().stream().forEach(t -> vars.add(t.asType()));
        } else if (linkInfo.type != null && utils.isDeclaredType(linkInfo.type)) {
            ((DeclaredType)linkInfo.type).getTypeArguments().stream().forEach(t -> vars.add(t));
        } else if (ctype != null && utils.isDeclaredType(ctype)) {
            ((DeclaredType)ctype).getTypeArguments().stream().forEach(t -> vars.add(t));
        } else if (linkInfo.typeElement != null) {
            linkInfo.typeElement.getTypeParameters().stream().forEach(t -> vars.add(t.asType()));
        } else {
            return links;
        }
        if ((linkInfo.includeTypeInClassLinkLabel && isClassLabel || linkInfo.includeTypeAsSepLink && !isClassLabel) && !vars.isEmpty()) {
            links.addContent("<");
            boolean many = false;
            for (TypeMirror t2 : vars) {
                if (many) {
                    links.addContent(",");
                }
                links.addContent(this.getTypeParameterLink(linkInfo, t2));
                many = true;
            }
            links.addContent(">");
        }
        return links;
    }

    public Content getTypeAnnotationLinks(LinkInfo linkInfo) {
        Utils utils = ((LinkInfoImpl)linkInfo).utils;
        Content links = this.newContent();
        if (!utils.isAnnotated(linkInfo.type)) {
            return links;
        }
        List<? extends AnnotationMirror> annotations = linkInfo.type.getAnnotationMirrors();
        boolean needSpace = false;
        for (AnnotationMirror annotationMirror : annotations) {
            if (needSpace) {
                links.addContent(" ");
            }
            links.addContent(this.getTypeAnnotationLink(linkInfo, annotationMirror));
            needSpace = true;
        }
        links.addContent(" ");
        return links;
    }
}

