/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.tool;

import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.ClassFinder;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Context;
import java.util.EnumSet;
import javax.tools.JavaFileObject;
import jdk.javadoc.internal.tool.DocEnv;

public class JavadocClassFinder
extends ClassFinder {
    private DocEnv docenv;
    private EnumSet<JavaFileObject.Kind> all = EnumSet.of(JavaFileObject.Kind.CLASS, JavaFileObject.Kind.SOURCE, JavaFileObject.Kind.HTML);
    private EnumSet<JavaFileObject.Kind> noSource = EnumSet.of(JavaFileObject.Kind.CLASS, JavaFileObject.Kind.HTML);
    private final JavacTrees trees;

    public static JavadocClassFinder instance(Context context) {
        ClassFinder instance = (ClassFinder)context.get(classFinderKey);
        if (instance == null) {
            instance = new JavadocClassFinder(context);
        }
        return (JavadocClassFinder)instance;
    }

    public static void preRegister(Context context) {
        context.put(classFinderKey, new Context.Factory<ClassFinder>(){

            @Override
            public ClassFinder make(Context c) {
                return new JavadocClassFinder(c);
            }
        });
    }

    public JavadocClassFinder(Context context) {
        super(context);
        this.docenv = DocEnv.instance(context);
        this.preferSource = true;
        this.trees = JavacTrees.instance(context);
    }

    @Override
    protected EnumSet<JavaFileObject.Kind> getPackageFileKinds() {
        return this.docenv.docClasses ? this.noSource : this.all;
    }

    @Override
    protected void extraFileActions(Symbol.PackageSymbol pack, JavaFileObject fo) {
        if (fo.isNameCompatible("package", JavaFileObject.Kind.HTML)) {
            this.docenv.pkgToJavaFOMap.put(pack, fo);
            this.trees.putJavaFileObject(pack, fo);
        }
    }
}

