/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeMetadata;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.ArgumentAttr;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Flow;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.comp.InferenceContext;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.comp.TypeEnvs;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeCopier;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.GraphUtils;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Warner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;

public class DeferredAttr
extends JCTree.Visitor {
    protected static final Context.Key<DeferredAttr> deferredAttrKey = new Context.Key();
    final Attr attr;
    final ArgumentAttr argumentAttr;
    final Check chk;
    final JCDiagnostic.Factory diags;
    final Enter enter;
    final Infer infer;
    final Resolve rs;
    final Log log;
    final Symtab syms;
    final TreeMaker make;
    final TreeCopier<Void> treeCopier;
    final Type.TypeMapping<Void> deferredCopier;
    final Types types;
    final Flow flow;
    final Names names;
    final TypeEnvs typeEnvs;
    final JCTree stuckTree;
    DeferredTypeCompleter basicCompleter = new DeferredTypeCompleter(){

        @Override
        public Type complete(DeferredType dt, Attr.ResultInfo resultInfo, DeferredAttrContext deferredAttrContext) {
            switch (deferredAttrContext.mode) {
                case SPECULATIVE: {
                    Assert.check(dt.mode == null || dt.mode == AttrMode.SPECULATIVE);
                    JCTree speculativeTree = DeferredAttr.this.attribSpeculative(dt.tree, dt.env, resultInfo);
                    dt.speculativeCache.put(speculativeTree, resultInfo);
                    return speculativeTree.type;
                }
                case CHECK: {
                    Assert.check(dt.mode != null);
                    return DeferredAttr.this.attr.attribTree(dt.tree, dt.env, resultInfo);
                }
            }
            Assert.error();
            return null;
        }
    };
    DeferredStuckPolicy dummyStuckPolicy = new DeferredStuckPolicy(){

        @Override
        public boolean isStuck() {
            return false;
        }

        @Override
        public Set<Type> stuckVars() {
            return Collections.emptySet();
        }

        @Override
        public Set<Type> depVars() {
            return Collections.emptySet();
        }
    };
    protected UnenterScanner unenterScanner = new UnenterScanner();
    final DeferredAttrContext emptyDeferredAttrContext;

    public static DeferredAttr instance(Context context) {
        DeferredAttr instance = context.get(deferredAttrKey);
        if (instance == null) {
            instance = new DeferredAttr(context);
        }
        return instance;
    }

    protected DeferredAttr(Context context) {
        context.put(deferredAttrKey, this);
        this.attr = Attr.instance(context);
        this.argumentAttr = ArgumentAttr.instance(context);
        this.chk = Check.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.enter = Enter.instance(context);
        this.infer = Infer.instance(context);
        this.rs = Resolve.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.make = TreeMaker.instance(context);
        this.types = Types.instance(context);
        this.flow = Flow.instance(context);
        this.names = Names.instance(context);
        this.stuckTree = this.make.Ident(this.names.empty).setType(Type.stuckType);
        this.typeEnvs = TypeEnvs.instance(context);
        this.emptyDeferredAttrContext = new DeferredAttrContext(AttrMode.CHECK, null, Resolve.MethodResolutionPhase.BOX, this.infer.emptyContext, null, null){

            @Override
            void addDeferredAttrNode(DeferredType dt, Attr.ResultInfo ri, DeferredStuckPolicy deferredStuckPolicy) {
                Assert.error("Empty deferred context!");
            }

            @Override
            void complete() {
                Assert.error("Empty deferred context!");
            }

            public String toString() {
                return "Empty deferred context!";
            }
        };
        this.treeCopier = new TreeCopier<Void>(this.make){

            @Override
            public JCTree visitNewClass(NewClassTree node, Void p) {
                JCTree.JCNewClass t = (JCTree.JCNewClass)node;
                if (TreeInfo.isDiamond(t)) {
                    JCTree.JCExpression encl = this.copy(t.encl, p);
                    List<JCTree.JCExpression> typeargs = this.copy(t.typeargs, p);
                    JCTree.JCExpression clazz = this.copy(t.clazz, p);
                    List<JCTree.JCExpression> args = this.copy(t.args, p);
                    JCTree.JCClassDecl def = null;
                    return DeferredAttr.this.make.at(t.pos).NewClass(encl, typeargs, clazz, args, def);
                }
                return super.visitNewClass(node, p);
            }
        };
        this.deferredCopier = new Type.TypeMapping<Void>(){

            @Override
            public Type visitType(Type t, Void v) {
                if (t.hasTag(TypeTag.DEFERRED)) {
                    DeferredType dt = (DeferredType)t;
                    return new DeferredType(DeferredAttr.this.treeCopier.copy(dt.tree), dt.env);
                }
                return t;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JCTree.JCLambda attribSpeculativeLambda(JCTree.JCLambda that, Env<AttrContext> env, Attr.ResultInfo resultInfo) {
        ListBuffer<JCTree.JCStatement> stats = new ListBuffer<JCTree.JCStatement>();
        stats.addAll((Collection<JCTree.JCStatement>)that.params);
        if (that.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
            stats.add(this.make.Return((JCTree.JCExpression)that.body));
        } else {
            stats.add((JCTree.JCBlock)that.body);
        }
        JCTree.JCBlock lambdaBlock = this.make.Block(0L, stats.toList());
        Env<AttrContext> localEnv = this.attr.lambdaEnv(that, env);
        try {
            ((AttrContext)localEnv.info).returnResult = resultInfo;
            JCTree.JCBlock speculativeTree = (JCTree.JCBlock)this.attribSpeculative(lambdaBlock, localEnv, resultInfo);
            List<JCTree.JCVariableDecl> args = speculativeTree.getStatements().stream().filter(s -> s.hasTag(JCTree.Tag.VARDEF)).map(t -> (JCTree.JCVariableDecl)t).collect(List.collector());
            JCTree lambdaBody = (JCTree)((List)speculativeTree.getStatements()).last();
            if (lambdaBody.hasTag(JCTree.Tag.RETURN)) {
                lambdaBody = ((JCTree.JCReturn)lambdaBody).expr;
            }
            JCTree.JCLambda speculativeLambda = this.make.Lambda(args, lambdaBody);
            this.attr.preFlow(speculativeLambda);
            this.flow.analyzeLambda(env, speculativeLambda, this.make, false);
            JCTree.JCLambda jCLambda = speculativeLambda;
            return jCLambda;
        }
        finally {
            ((AttrContext)localEnv.info).scope.leave();
        }
    }

    JCTree attribSpeculative(JCTree tree, Env<AttrContext> env, Attr.ResultInfo resultInfo) {
        return this.attribSpeculative(tree, env, resultInfo, this.treeCopier, newTree -> new DeferredAttrDiagHandler(this.log, (JCTree)newTree));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <Z> JCTree attribSpeculative(JCTree tree, Env<AttrContext> env, Attr.ResultInfo resultInfo, TreeCopier<Z> deferredCopier, Function<JCTree, Log.DeferredDiagnosticHandler> diagHandlerCreator) {
        JCTree newTree = deferredCopier.copy(tree);
        Env<AttrContext> speculativeEnv = env.dup(newTree, ((AttrContext)env.info).dup(((AttrContext)env.info).scope.dupUnshared(((AttrContext)env.info).scope.owner)));
        ((AttrContext)speculativeEnv.info).isSpeculative = true;
        Log.DeferredDiagnosticHandler deferredDiagnosticHandler = diagHandlerCreator.apply(newTree);
        try {
            this.attr.attribTree(newTree, speculativeEnv, resultInfo);
            this.unenterScanner.scan(newTree);
            JCTree jCTree = newTree;
            return jCTree;
        }
        finally {
            this.unenterScanner.scan(newTree);
            this.log.popDiagnosticHandler(deferredDiagnosticHandler);
        }
    }

    class OverloadStuckPolicy
    extends CheckStuckPolicy
    implements DeferredStuckPolicy {
        boolean stuck;

        @Override
        public boolean isStuck() {
            return super.isStuck() || this.stuck;
        }

        public OverloadStuckPolicy(Attr.ResultInfo resultInfo, DeferredType dt) {
            super(resultInfo, dt);
        }

        @Override
        public void visitLambda(JCTree.JCLambda tree) {
            super.visitLambda(tree);
            if (tree.paramKind == JCTree.JCLambda.ParameterKind.IMPLICIT) {
                this.stuck = true;
            }
        }

        @Override
        public void visitReference(JCTree.JCMemberReference tree) {
            super.visitReference(tree);
            if (tree.overloadKind == JCTree.JCMemberReference.OverloadKind.OVERLOADED) {
                this.stuck = true;
            }
        }
    }

    class CheckStuckPolicy
    extends PolyScanner
    implements DeferredStuckPolicy,
    Infer.FreeTypeListener {
        Type pt;
        InferenceContext inferenceContext;
        Set<Type> stuckVars = new LinkedHashSet<Type>();
        Set<Type> depVars = new LinkedHashSet<Type>();

        @Override
        public boolean isStuck() {
            return !this.stuckVars.isEmpty();
        }

        @Override
        public Set<Type> stuckVars() {
            return this.stuckVars;
        }

        @Override
        public Set<Type> depVars() {
            return this.depVars;
        }

        public CheckStuckPolicy(Attr.ResultInfo resultInfo, DeferredType dt) {
            this.pt = resultInfo.pt;
            this.inferenceContext = resultInfo.checkContext.inferenceContext();
            this.scan(dt.tree);
            if (!this.stuckVars.isEmpty()) {
                resultInfo.checkContext.inferenceContext().addFreeTypeListener(List.from(this.stuckVars), this);
            }
        }

        @Override
        public void typesInferred(InferenceContext inferenceContext) {
            this.stuckVars.clear();
        }

        @Override
        public void visitLambda(JCTree.JCLambda tree) {
            if (this.inferenceContext.inferenceVars().contains(this.pt)) {
                this.stuckVars.add(this.pt);
            }
            if (!DeferredAttr.this.types.isFunctionalInterface(this.pt)) {
                return;
            }
            Type descType = DeferredAttr.this.types.findDescriptorType(this.pt);
            List<Type> freeArgVars = this.inferenceContext.freeVarsIn(descType.getParameterTypes());
            if (tree.paramKind == JCTree.JCLambda.ParameterKind.IMPLICIT && freeArgVars.nonEmpty()) {
                this.stuckVars.addAll(freeArgVars);
                this.depVars.addAll(this.inferenceContext.freeVarsIn(descType.getReturnType()));
            }
            this.scanLambdaBody(tree, descType.getReturnType());
        }

        @Override
        public void visitReference(JCTree.JCMemberReference tree) {
            this.scan(tree.expr);
            if (this.inferenceContext.inferenceVars().contains(this.pt)) {
                this.stuckVars.add(this.pt);
                return;
            }
            if (!DeferredAttr.this.types.isFunctionalInterface(this.pt)) {
                return;
            }
            Type descType = DeferredAttr.this.types.findDescriptorType(this.pt);
            List<Type> freeArgVars = this.inferenceContext.freeVarsIn(descType.getParameterTypes());
            if (freeArgVars.nonEmpty() && tree.overloadKind == JCTree.JCMemberReference.OverloadKind.OVERLOADED) {
                this.stuckVars.addAll(freeArgVars);
                this.depVars.addAll(this.inferenceContext.freeVarsIn(descType.getReturnType()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void scanLambdaBody(JCTree.JCLambda lambda, final Type pt) {
            if (lambda.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                Type prevPt = this.pt;
                try {
                    this.pt = pt;
                    this.scan(lambda.body);
                }
                finally {
                    this.pt = prevPt;
                }
            } else {
                LambdaReturnScanner lambdaScanner = new LambdaReturnScanner(){

                    @Override
                    public void visitReturn(JCTree.JCReturn tree) {
                        if (tree.expr != null) {
                            Type prevPt = CheckStuckPolicy.this.pt;
                            try {
                                CheckStuckPolicy.this.pt = pt;
                                CheckStuckPolicy.this.scan(tree.expr);
                            }
                            finally {
                                CheckStuckPolicy.this.pt = prevPt;
                            }
                        }
                    }
                };
                lambdaScanner.scan(lambda.body);
            }
        }
    }

    static class LambdaReturnScanner
    extends FilterScanner {
        LambdaReturnScanner() {
            super(EnumSet.of(JCTree.Tag.BLOCK, new JCTree.Tag[]{JCTree.Tag.CASE, JCTree.Tag.CATCH, JCTree.Tag.DOLOOP, JCTree.Tag.FOREACHLOOP, JCTree.Tag.FORLOOP, JCTree.Tag.IF, JCTree.Tag.RETURN, JCTree.Tag.SYNCHRONIZED, JCTree.Tag.SWITCH, JCTree.Tag.TRY, JCTree.Tag.WHILELOOP}));
        }
    }

    static class PolyScanner
    extends FilterScanner {
        PolyScanner() {
            super(EnumSet.of(JCTree.Tag.CONDEXPR, JCTree.Tag.PARENS, JCTree.Tag.LAMBDA, JCTree.Tag.REFERENCE));
        }
    }

    static abstract class FilterScanner
    extends TreeScanner {
        final Filter<JCTree> treeFilter;

        FilterScanner(final Set<JCTree.Tag> validTags) {
            this.treeFilter = new Filter<JCTree>(){

                @Override
                public boolean accepts(JCTree t) {
                    return validTags.contains((Object)t.getTag());
                }
            };
        }

        @Override
        public void scan(JCTree tree) {
            if (tree != null) {
                if (this.treeFilter.accepts(tree)) {
                    super.scan(tree);
                } else {
                    this.skip(tree);
                }
            }
        }

        void skip(JCTree tree) {
        }
    }

    public class RecoveryDeferredTypeMap
    extends DeferredTypeMap {
        public RecoveryDeferredTypeMap(AttrMode mode, Symbol msym, Resolve.MethodResolutionPhase phase) {
            super(mode, msym, phase != null ? phase : Resolve.MethodResolutionPhase.BOX);
        }

        @Override
        protected Type typeOf(DeferredType dt) {
            Type owntype = super.typeOf(dt);
            return owntype == Type.noType ? this.recover(dt) : owntype;
        }

        private Type recover(DeferredType dt) {
            Attr attr = DeferredAttr.this.attr;
            attr.getClass();
            dt.check(new Attr.RecoveryInfo(attr, this.deferredAttrContext){
                {
                    Attr attr = x0;
                    attr.getClass();
                    super(attr, deferredAttrContext);
                }

                @Override
                protected Type check(JCDiagnostic.DiagnosticPosition pos, Type found) {
                    return DeferredAttr.this.chk.checkNonVoid(pos, super.check(pos, found));
                }
            });
            return super.visit(dt);
        }
    }

    class DeferredTypeMap
    extends Type.TypeMapping<Void> {
        DeferredAttrContext deferredAttrContext;

        protected DeferredTypeMap(AttrMode mode, Symbol msym, Resolve.MethodResolutionPhase phase) {
            this.deferredAttrContext = new DeferredAttrContext(mode, msym, phase, DeferredAttr.this.infer.emptyContext, DeferredAttr.this.emptyDeferredAttrContext, DeferredAttr.this.types.noWarnings);
        }

        @Override
        public Type visitType(Type t, Void _unused) {
            if (!t.hasTag(TypeTag.DEFERRED)) {
                return super.visitType(t, (Object)null);
            }
            DeferredType dt = (DeferredType)t;
            return this.typeOf(dt);
        }

        protected Type typeOf(DeferredType dt) {
            switch (this.deferredAttrContext.mode) {
                case CHECK: {
                    return dt.tree.type == null ? Type.noType : dt.tree.type;
                }
                case SPECULATIVE: {
                    return dt.speculativeType(this.deferredAttrContext.msym, this.deferredAttrContext.phase);
                }
            }
            Assert.error();
            return null;
        }
    }

    class DeferredAttrNode {
        DeferredType dt;
        Attr.ResultInfo resultInfo;
        DeferredStuckPolicy deferredStuckPolicy;

        DeferredAttrNode(DeferredType dt, Attr.ResultInfo resultInfo, DeferredStuckPolicy deferredStuckPolicy) {
            this.dt = dt;
            this.resultInfo = resultInfo;
            this.deferredStuckPolicy = deferredStuckPolicy;
        }

        boolean process(final DeferredAttrContext deferredAttrContext) {
            switch (deferredAttrContext.mode) {
                case SPECULATIVE: {
                    if (this.deferredStuckPolicy.isStuck()) {
                        this.dt.check(this.resultInfo, DeferredAttr.this.dummyStuckPolicy, new StructuralStuckChecker());
                        return true;
                    }
                    Assert.error("Cannot get here");
                }
                case CHECK: {
                    if (this.deferredStuckPolicy.isStuck()) {
                        if (deferredAttrContext.parent != DeferredAttr.this.emptyDeferredAttrContext && Type.containsAny(deferredAttrContext.parent.inferenceContext.inferencevars, List.from(this.deferredStuckPolicy.stuckVars()))) {
                            deferredAttrContext.parent.addDeferredAttrNode(this.dt, this.resultInfo.dup(new Check.NestedCheckContext(this.resultInfo.checkContext){

                                @Override
                                public InferenceContext inferenceContext() {
                                    return deferredAttrContext.parent.inferenceContext;
                                }

                                @Override
                                public DeferredAttrContext deferredAttrContext() {
                                    return deferredAttrContext.parent;
                                }
                            }), this.deferredStuckPolicy);
                            this.dt.tree.type = Type.stuckType;
                            return true;
                        }
                        return false;
                    }
                    Assert.check(!deferredAttrContext.insideOverloadPhase(), "attribution shouldn't be happening here");
                    Attr.ResultInfo instResultInfo = this.resultInfo.dup(deferredAttrContext.inferenceContext.asInstType(this.resultInfo.pt));
                    this.dt.check(instResultInfo, DeferredAttr.this.dummyStuckPolicy, DeferredAttr.this.basicCompleter);
                    return true;
                }
            }
            throw new AssertionError((Object)"Bad mode");
        }

        class LambdaBodyStructChecker
        extends TreeScanner {
            boolean isVoidCompatible = true;
            boolean isPotentiallyValueCompatible = true;

            LambdaBodyStructChecker() {
            }

            @Override
            public void visitClassDef(JCTree.JCClassDecl tree) {
            }

            @Override
            public void visitLambda(JCTree.JCLambda tree) {
            }

            @Override
            public void visitNewClass(JCTree.JCNewClass tree) {
            }

            @Override
            public void visitReturn(JCTree.JCReturn tree) {
                if (tree.expr != null) {
                    this.isVoidCompatible = false;
                } else {
                    this.isPotentiallyValueCompatible = false;
                }
            }
        }

        class StructuralStuckChecker
        extends TreeScanner
        implements DeferredTypeCompleter {
            Attr.ResultInfo resultInfo;
            InferenceContext inferenceContext;
            Env<AttrContext> env;

            StructuralStuckChecker() {
            }

            @Override
            public Type complete(DeferredType dt, Attr.ResultInfo resultInfo, DeferredAttrContext deferredAttrContext) {
                this.resultInfo = resultInfo;
                this.inferenceContext = deferredAttrContext.inferenceContext;
                this.env = dt.env;
                dt.tree.accept(this);
                dt.speculativeCache.put(DeferredAttr.this.stuckTree, resultInfo);
                return Type.noType;
            }

            @Override
            public void visitLambda(JCTree.JCLambda tree) {
                Check.CheckContext checkContext = this.resultInfo.checkContext;
                Type pt = this.resultInfo.pt;
                if (!this.inferenceContext.inferencevars.contains(pt)) {
                    Type descriptorType = null;
                    try {
                        descriptorType = DeferredAttr.this.types.findDescriptorType(pt);
                    }
                    catch (Types.FunctionDescriptorLookupError ex) {
                        checkContext.report(null, ex.getDiagnostic());
                    }
                    if (descriptorType.getParameterTypes().length() != tree.params.length()) {
                        checkContext.report(tree, DeferredAttr.this.diags.fragment("incompatible.arg.types.in.lambda", new Object[0]));
                    }
                    Type currentReturnType = descriptorType.getReturnType();
                    boolean returnTypeIsVoid = currentReturnType.hasTag(TypeTag.VOID);
                    if (tree.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                        boolean isExpressionCompatible;
                        boolean bl = isExpressionCompatible = !returnTypeIsVoid || TreeInfo.isExpressionStatement((JCTree.JCExpression)tree.getBody());
                        if (!isExpressionCompatible) {
                            this.resultInfo.checkContext.report(tree.pos(), DeferredAttr.this.diags.fragment("incompatible.ret.type.in.lambda", DeferredAttr.this.diags.fragment("missing.ret.val", currentReturnType)));
                        }
                    } else {
                        LambdaBodyStructChecker lambdaBodyChecker = new LambdaBodyStructChecker();
                        tree.body.accept(lambdaBodyChecker);
                        boolean isVoidCompatible = lambdaBodyChecker.isVoidCompatible;
                        if (returnTypeIsVoid) {
                            if (!isVoidCompatible) {
                                this.resultInfo.checkContext.report(tree.pos(), DeferredAttr.this.diags.fragment("unexpected.ret.val", new Object[0]));
                            }
                        } else {
                            boolean isValueCompatible;
                            boolean bl = isValueCompatible = lambdaBodyChecker.isPotentiallyValueCompatible && !this.canLambdaBodyCompleteNormally(tree);
                            if (!isValueCompatible && !isVoidCompatible) {
                                DeferredAttr.this.log.error(tree.body.pos(), "lambda.body.neither.value.nor.void.compatible", new Object[0]);
                            }
                            if (!isValueCompatible) {
                                this.resultInfo.checkContext.report(tree.pos(), DeferredAttr.this.diags.fragment("incompatible.ret.type.in.lambda", DeferredAttr.this.diags.fragment("missing.ret.val", currentReturnType)));
                            }
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            boolean canLambdaBodyCompleteNormally(JCTree.JCLambda tree) {
                List<JCTree.JCVariableDecl> oldParams = tree.params;
                ArgumentAttr.LocalCacheContext localCacheContext = DeferredAttr.this.argumentAttr.withLocalCacheContext();
                try {
                    tree.params = tree.params.stream().map(vd -> DeferredAttr.this.make.VarDef(vd.mods, vd.name, DeferredAttr.this.make.Erroneous(), null)).collect(List.collector());
                    boolean bl = DeferredAttr.this.attribSpeculativeLambda((JCTree.JCLambda)tree, this.env, (Attr.ResultInfo)DeferredAttr.this.attr.unknownExprInfo).canCompleteNormally;
                    return bl;
                }
                finally {
                    localCacheContext.leave();
                    tree.params = oldParams;
                }
            }

            @Override
            public void visitNewClass(JCTree.JCNewClass tree) {
            }

            @Override
            public void visitApply(JCTree.JCMethodInvocation tree) {
            }

            @Override
            public void visitReference(JCTree.JCMemberReference tree) {
                Check.CheckContext checkContext = this.resultInfo.checkContext;
                Type pt = this.resultInfo.pt;
                if (!this.inferenceContext.inferencevars.contains(pt)) {
                    try {
                        DeferredAttr.this.types.findDescriptorType(pt);
                    }
                    catch (Types.FunctionDescriptorLookupError ex) {
                        checkContext.report(null, ex.getDiagnostic());
                    }
                    Env<AttrContext> localEnv = this.env.dup(tree);
                    JCTree.JCExpression exprTree = (JCTree.JCExpression)DeferredAttr.this.attribSpeculative(tree.getQualifierExpression(), localEnv, DeferredAttr.this.attr.memberReferenceQualifierResult(tree));
                    ListBuffer<Type.JCNoType> argtypes = new ListBuffer<Type.JCNoType>();
                    for (Type t : DeferredAttr.this.types.findDescriptorType(pt).getParameterTypes()) {
                        argtypes.append(Type.noType);
                    }
                    JCTree.JCMemberReference mref2 = new TreeCopier(DeferredAttr.this.make).copy(tree);
                    mref2.expr = exprTree;
                    Symbol lookupSym = (Symbol)DeferredAttr.this.rs.resolveMemberReference(localEnv, (JCTree.JCMemberReference)mref2, (Type)exprTree.type, (Name)tree.name, argtypes.toList(), List.nil(), (Resolve.MethodCheck)DeferredAttr.this.rs.arityMethodCheck, (InferenceContext)this.inferenceContext, (Resolve.ReferenceChooser)DeferredAttr.this.rs.structuralReferenceChooser).fst;
                    switch (lookupSym.kind) {
                        case WRONG_MTH: 
                        case WRONG_MTHS: {
                            checkContext.report(tree, DeferredAttr.this.diags.fragment(CompilerProperties.Fragments.IncompatibleArgTypesInMref));
                            break;
                        }
                        case ABSENT_MTH: 
                        case STATICERR: {
                            checkContext.report(tree, ((Resolve.ResolveError)lookupSym).getDiagnostic(JCDiagnostic.DiagnosticType.FRAGMENT, tree, exprTree.type.tsym, exprTree.type, tree.name, argtypes.toList(), List.nil()));
                        }
                    }
                }
            }
        }
    }

    class DeferredAttrContext {
        final AttrMode mode;
        final Symbol msym;
        final Resolve.MethodResolutionPhase phase;
        final InferenceContext inferenceContext;
        final DeferredAttrContext parent;
        final Warner warn;
        ArrayList<DeferredAttrNode> deferredAttrNodes = new ArrayList();

        DeferredAttrContext(AttrMode mode, Symbol msym, Resolve.MethodResolutionPhase phase, InferenceContext inferenceContext, DeferredAttrContext parent, Warner warn) {
            this.mode = mode;
            this.msym = msym;
            this.phase = phase;
            this.parent = parent;
            this.warn = warn;
            this.inferenceContext = inferenceContext;
        }

        void addDeferredAttrNode(DeferredType dt, Attr.ResultInfo resultInfo, DeferredStuckPolicy deferredStuckPolicy) {
            this.deferredAttrNodes.add(new DeferredAttrNode(dt, resultInfo, deferredStuckPolicy));
        }

        void complete() {
            while (!this.deferredAttrNodes.isEmpty()) {
                boolean progress = false;
                for (DeferredAttrNode deferredAttrNode : List.from(this.deferredAttrNodes)) {
                    if (!deferredAttrNode.process(this)) continue;
                    this.deferredAttrNodes.remove(deferredAttrNode);
                    progress = true;
                }
                if (progress) continue;
                if (this.insideOverloadPhase()) {
                    for (DeferredAttrNode deferredNode : this.deferredAttrNodes) {
                        deferredNode.dt.tree.type = Type.noType;
                    }
                    return;
                }
                try {
                    DeferredAttrNode toUnstuck = this.pickDeferredNode();
                    this.inferenceContext.solveAny(List.from(toUnstuck.deferredStuckPolicy.stuckVars()), this.warn);
                    this.inferenceContext.notifyChange();
                }
                catch (Infer.GraphStrategy.NodeNotFoundException ex) {
                    break;
                }
            }
        }

        public boolean insideOverloadPhase() {
            DeferredAttrContext dac = this;
            if (dac == DeferredAttr.this.emptyDeferredAttrContext) {
                return false;
            }
            if (dac.mode == AttrMode.SPECULATIVE) {
                return true;
            }
            return dac.parent.insideOverloadPhase();
        }

        DeferredAttrNode pickDeferredNode() {
            List nodes = this.deferredAttrNodes.stream().map(x$0 -> new StuckNode((DeferredAttrNode)x$0)).collect(List.collector());
            for (StuckNode sn1 : nodes) {
                for (Type t : ((DeferredAttrNode)sn1.data).deferredStuckPolicy.stuckVars()) {
                    for (StuckNode sn2 : nodes) {
                        if (sn1 == sn2 || !((DeferredAttrNode)sn2.data).deferredStuckPolicy.depVars().contains(t)) continue;
                        sn1.deps.add(sn2);
                    }
                }
            }
            List csn = GraphUtils.tarjan(nodes).get(0);
            return csn.length() == 1 ? (DeferredAttrNode)((StuckNode)csn.get((int)0)).data : this.deferredAttrNodes.get(0);
        }

        class StuckNode
        extends GraphUtils.TarjanNode<DeferredAttrNode, StuckNode> {
            Set<StuckNode> deps;

            StuckNode(DeferredAttrNode data) {
                super(data);
                this.deps = new HashSet<StuckNode>();
            }

            @Override
            public GraphUtils.DependencyKind[] getSupportedDependencyKinds() {
                return new GraphUtils.DependencyKind[]{Infer.DependencyKind.STUCK};
            }

            @Override
            public Collection<? extends StuckNode> getDependenciesByKind(GraphUtils.DependencyKind dk) {
                if (dk == Infer.DependencyKind.STUCK) {
                    return this.deps;
                }
                throw new IllegalStateException();
            }

            @Override
            public Iterable<? extends StuckNode> getAllDependencies() {
                return this.deps;
            }
        }
    }

    static class DeferredAttrDiagHandler
    extends Log.DeferredDiagnosticHandler {
        DeferredAttrDiagHandler(Log log, final JCTree newTree) {
            super(log, new Filter<JCDiagnostic>(){

                @Override
                public boolean accepts(JCDiagnostic d) {
                    PosScanner posScanner = new PosScanner(d.getDiagnosticPosition());
                    posScanner.scan(newTree);
                    return posScanner.found;
                }
            });
        }

        static class PosScanner
        extends TreeScanner {
            JCDiagnostic.DiagnosticPosition pos;
            boolean found = false;

            PosScanner(JCDiagnostic.DiagnosticPosition pos) {
                this.pos = pos;
            }

            @Override
            public void scan(JCTree tree) {
                if (tree != null && tree.pos() == this.pos) {
                    this.found = true;
                }
                super.scan(tree);
            }
        }
    }

    class UnenterScanner
    extends TreeScanner {
        UnenterScanner() {
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            Symbol.ClassSymbol csym = tree.sym;
            if (csym == null) {
                return;
            }
            DeferredAttr.this.typeEnvs.remove(csym);
            DeferredAttr.this.chk.compiled.remove(csym.flatname);
            DeferredAttr.this.chk.clearLocalClassNameIndexes(csym);
            DeferredAttr.this.syms.classes.remove(csym.flatname);
            super.visitClassDef(tree);
        }
    }

    public static enum AttrMode {
        SPECULATIVE,
        CHECK;

    }

    static interface DeferredStuckPolicy {
        public boolean isStuck();

        public Set<Type> stuckVars();

        public Set<Type> depVars();
    }

    static interface DeferredTypeCompleter {
        public Type complete(DeferredType var1, Attr.ResultInfo var2, DeferredAttrContext var3);
    }

    public class DeferredType
    extends Type {
        public JCTree.JCExpression tree;
        Env<AttrContext> env;
        AttrMode mode;
        boolean pertinentToApplicability;
        SpeculativeCache speculativeCache;

        DeferredType(JCTree.JCExpression tree, Env<AttrContext> env) {
            super(null, TypeMetadata.EMPTY);
            this.pertinentToApplicability = true;
            this.tree = tree;
            this.env = DeferredAttr.this.attr.copyEnv(env);
            this.speculativeCache = new SpeculativeCache();
        }

        @Override
        public DeferredType cloneWithMetadata(TypeMetadata md) {
            throw new AssertionError((Object)"Cannot add metadata to a deferred type");
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.DEFERRED;
        }

        @Override
        public String toString() {
            return "DeferredType";
        }

        Type speculativeType(Symbol msym, Resolve.MethodResolutionPhase phase) {
            SpeculativeCache.Entry e = this.speculativeCache.get(msym, phase);
            return e != null ? e.speculativeTree.type : Type.noType;
        }

        JCTree speculativeTree(DeferredAttrContext deferredAttrContext) {
            SpeculativeCache.Entry e = this.speculativeCache.get(deferredAttrContext.msym, deferredAttrContext.phase);
            return e != null ? e.speculativeTree : DeferredAttr.this.stuckTree;
        }

        DeferredTypeCompleter completer() {
            return DeferredAttr.this.basicCompleter;
        }

        Type check(Attr.ResultInfo resultInfo) {
            DeferredStuckPolicy deferredStuckPolicy = resultInfo.pt.hasTag(TypeTag.NONE) || resultInfo.pt.isErroneous() ? DeferredAttr.this.dummyStuckPolicy : (resultInfo.checkContext.deferredAttrContext().mode == AttrMode.SPECULATIVE || resultInfo.checkContext.deferredAttrContext().insideOverloadPhase() ? new OverloadStuckPolicy(resultInfo, this) : new CheckStuckPolicy(resultInfo, this));
            return this.check(resultInfo, deferredStuckPolicy, this.completer());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Type check(Attr.ResultInfo resultInfo, DeferredStuckPolicy deferredStuckPolicy, DeferredTypeCompleter deferredTypeCompleter) {
            DeferredAttrContext deferredAttrContext = resultInfo.checkContext.deferredAttrContext();
            Assert.check(deferredAttrContext != DeferredAttr.this.emptyDeferredAttrContext);
            if (deferredStuckPolicy.isStuck()) {
                this.pertinentToApplicability = false;
                deferredAttrContext.addDeferredAttrNode(this, resultInfo, deferredStuckPolicy);
                return Type.noType;
            }
            try {
                Type type = deferredTypeCompleter.complete(this, resultInfo, deferredAttrContext);
                return type;
            }
            finally {
                this.mode = deferredAttrContext.mode;
            }
        }

        class SpeculativeCache {
            private Map<Symbol, List<Entry>> cache = new WeakHashMap<Symbol, List<Entry>>();

            SpeculativeCache() {
            }

            Entry get(Symbol msym, Resolve.MethodResolutionPhase phase) {
                List<Entry> entries = this.cache.get(msym);
                if (entries == null) {
                    return null;
                }
                for (Entry e : entries) {
                    if (!e.matches(phase)) continue;
                    return e;
                }
                return null;
            }

            void put(JCTree speculativeTree, Attr.ResultInfo resultInfo) {
                Symbol msym = resultInfo.checkContext.deferredAttrContext().msym;
                List<Entry> entries = this.cache.get(msym);
                if (entries == null) {
                    entries = List.nil();
                }
                this.cache.put(msym, entries.prepend(new Entry(speculativeTree, resultInfo)));
            }

            class Entry {
                JCTree speculativeTree;
                Attr.ResultInfo resultInfo;

                public Entry(JCTree speculativeTree, Attr.ResultInfo resultInfo) {
                    this.speculativeTree = speculativeTree;
                    this.resultInfo = resultInfo;
                }

                boolean matches(Resolve.MethodResolutionPhase phase) {
                    return this.resultInfo.checkContext.deferredAttrContext().phase == phase;
                }
            }
        }
    }
}

